% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaBinomial.R
\name{betaCoefficients}
\alias{betaCoefficients}
\title{Compute Parameters of a Beta Binomial Distribution}
\usage{
betaCoefficients(x, n)
}
\arguments{
\item{x}{A numeric vector of non-negative integers representing observed counts.}

\item{n}{The maximum number or the maximum possible value of `x`.}
}
\value{
A numeric vector containing the calculated parameters in the following order:
alpha (a), beta (b), mean (m), variance (var), and the maximum number (n).
}
\description{
This function calculates the \eqn{\alpha} (a) and \eqn{\beta} (b) parameters of a beta binomial
distribution, along with the mean (m), variance (var) based on the input vector `x`
and the maximum number `n`.
}
\details{
The beta-binomial distribution is a discrete probability distribution that models the
number of successes in a fixed number of trials, where the probability of success varies
from trial to trial. This variability in success probability is modeled by a beta
distribution. Such a calculation is particularly relevant in scenarios where there is
heterogeneity in success probabilities across trials, which is common in real-world
situations, as for example the number of correct solutions in a psychometric test, where
the test has a fixed number of items.
}
\examples{
x <- c(1, 2, 3, 4, 5)
n <- 5
betaCoefficients(x, n)

}
