% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predictNorm}
\alias{predictNorm}
\title{Retrieve norm value for raw score at a specific age}
\usage{
predictNorm(
  raw,
  A,
  model,
  minNorm = NULL,
  maxNorm = NULL,
  force = FALSE,
  covariate = NULL
)
}
\arguments{
\item{raw}{The raw value, either single numeric or list of values}

\item{A}{the age, either single numeric or list of values}

\item{model}{The regression model or a cnorm object}

\item{minNorm}{The lower bound of the norm score range}

\item{maxNorm}{The upper bound of the norm score range}

\item{force}{Try to resolve missing norm scores in case of inconsistent models}

\item{covariate}{In case, a covariate has been used, please specify the degree of the covariate /
the specific value here.}
}
\value{
The predicted norm score for a raw score, either single value or list of results
}
\description{
In real test scenarios, usually the results are available as raw values, for
which norm scores have to be looked up. This function conducts this reverse
transformation via a numerical solution: A precise norm table is generated and
the closest fitting norm score for a raw score is returned.
}
\examples{
# Generate cnorm object from example data
cnorm.elfe <- cnorm(raw = elfe$raw, group = elfe$group)

# return norm value for raw value 21 for grade 2, month 9
specificNormValue <- predictNorm(raw = 21, A = 2.75, cnorm.elfe)

}
\seealso{
Other predict: 
\code{\link{derivationTable}()},
\code{\link{getNormCurve}()},
\code{\link{normTable}()},
\code{\link{predictRaw}()},
\code{\link{rawTable}()}
}
\concept{predict}
