% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxcox.R
\name{predictNormBC}
\alias{predictNormBC}
\title{Calculate the norm value for a given raw value based on the parametric box cox distribution}
\usage{
predictNormBC(boxcoxParameters, raw, scale = "percentile")
}
\arguments{
\item{boxcoxParameters}{The parameters of the box cox power function, calculated via 'boxcox'}

\item{raw}{The raw value (>0)}

\item{scale}{type of norm scale, either T, IQ, z or percentile (= no
transformation; default); a double vector with the mean and standard deviation can as well,
be provided f. e. c(10, 3) for Wechsler scale index points}
}
\value{
the predicted raw value
}
\description{
In addition to the numeric solution of the inversion of the regression function applied in
'predictNorm', this function
can be used retrieving the norm scores at a specific age via the parametric box cox power
transformation. Please provide the box cox parameters retrieved via the 'boxcox'-function and
a raw value.
}
\examples{
# model sample data set
model <- bestModel(prepareData())

# fitting scores of regression model box cox power function at specific age and retrieving
# the parameters for the box cox power function
bcParameters <- boxcox(model, 3)

# predict norm value for raw value 15 at age 3 based on the regression model and via box cox
predictNormBC(bcParameters, 15, scale="T")
predictNorm(15, 3, model, minNorm=25, maxNorm=75)
}
\references{
Cole, T. J., & Green, P. J. (1992). Smoothing reference centile curves: the LMS method and penalized
likelihood. Statistics in medicine, 11(10), 1305-1319.

Box, G. E., & Cox, D. R. (1964). An analysis of transformations. Journal of the Royal Statistical
Society. Series B (Methodological), 211-252.
}
\seealso{
boxcox, predictNorm, predictRawBC
}
