% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRNfuns.R
\name{plot_upset}
\alias{plot_upset}
\title{Visualise the overlap of edges between different networks}
\usage{
plot_upset(weightMatList, plotConnections)
}
\arguments{
\item{weightMatList}{a list of (weighted) adjacency matrices;
each list element must be an adjacency matrix with regulators in rows,
targets in columns}

\item{plotConnections}{the number of connections to subset to}
}
\value{
An UpSet plot. See UpSetR package for more details.
}
\description{
This function creates an UpSet plot of the intersections
and specific differences of the edges in the input networks.
}
\examples{
weightMat1 <- matrix(
  c(0.1, 0.4, 0.8, 0.3), nrow = 2, ncol = 2,
  dimnames = list("regulators" = c("r1", "r2"), "targets" = c("t1", "t2"))
)
weightMat2 <- matrix(
  c(0.1, 0.2, 0.8, 0.3), nrow = 2, ncol = 2,
  dimnames = list("regulators" = c("r1", "r2"), "targets" = c("t1", "t2"))
)
plot_upset(list(weightMat1, weightMat2), 2)
}
