% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_bsvar_sv.R
\name{specify_starting_values_bsvar_sv}
\alias{specify_starting_values_bsvar_sv}
\title{R6 Class Representing StartingValuesBSVARSV}
\description{
The class StartingValuesBSVARSV presents starting values for the bsvar model with Stochastic Volatility heteroskedasticity.
}
\examples{
# starting values for a bsvar model for a 3-variable system
sv = specify_starting_values_bsvar_sv$new(N = 3, p = 1, T = 100)


## ------------------------------------------------
## Method `specify_starting_values_bsvar_sv$get_starting_values`
## ------------------------------------------------

# starting values for a bsvar model with 1 lag for a 3-variable system
sv = specify_starting_values_bsvar_sv$new(N = 3, p = 1, T = 100)
sv$get_starting_values()   # show starting values as list


## ------------------------------------------------
## Method `specify_starting_values_bsvar_sv$set_starting_values`
## ------------------------------------------------

# starting values for a bsvar model with 1 lag for a 3-variable system
sv = specify_starting_values_bsvar_sv$new(N = 3, p = 1, T = 100)

# Modify the starting values by:
sv_list = sv$get_starting_values()   # getting them as list
sv_list$A <- matrix(rnorm(12), 3, 4) # modifying the entry
sv$set_starting_values(sv_list)      # providing to the class object

}
\section{Super class}{
\code{bsvars::StartingValuesBSVAR} -> \code{StartingValuesBSVARSV}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{A}}{an \code{NxK} matrix of starting values for the parameter \eqn{A}.}

\item{\code{B}}{an \code{NxN} matrix of starting values for the parameter \eqn{B}.}

\item{\code{hyper}}{a \code{(2*N+1)x2} matrix of starting values for the shrinkage hyper-parameters of the 
hierarchical prior distribution.}

\item{\code{h}}{an \code{NxT} matrix with the starting values of the log-volatility processes.}

\item{\code{rho}}{an \code{N}-vector with values of SV autoregressive parameters.}

\item{\code{omega}}{an \code{N}-vector with values of SV process conditional standard deviations.}

\item{\code{sigma2v}}{an \code{N}-vector with values of SV process conditional variances.}

\item{\code{S}}{an \code{NxT} integer matrix with the auxiliary mixture component indicators.}

\item{\code{sigma2_omega}}{an \code{N}-vector with variances of the zero-mean normal prior for \eqn{\omega_n}.}

\item{\code{s_}}{a positive scalar with the scale of the gamma prior of the hierarchical prior for \eqn{\sigma^2_{\omega}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-StartingValuesBSVARSV-new}{\code{specify_starting_values_bsvar_sv$new()}}
\item \href{#method-StartingValuesBSVARSV-get_starting_values}{\code{specify_starting_values_bsvar_sv$get_starting_values()}}
\item \href{#method-StartingValuesBSVARSV-set_starting_values}{\code{specify_starting_values_bsvar_sv$set_starting_values()}}
\item \href{#method-StartingValuesBSVARSV-clone}{\code{specify_starting_values_bsvar_sv$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StartingValuesBSVARSV-new"></a>}}
\if{latex}{\out{\hypertarget{method-StartingValuesBSVARSV-new}{}}}
\subsection{Method \code{new()}}{
Create new starting values StartingValuesBSVARSV.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_starting_values_bsvar_sv$new(N, p, T, d = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{N}}{a positive integer - the number of dependent variables in the model.}

\item{\code{p}}{a positive integer - the autoregressive lag order of the SVAR model.}

\item{\code{T}}{a positive integer - the the time series dimension of the dependent variable matrix \eqn{Y}.}

\item{\code{d}}{a positive integer - the number of \code{exogenous} variables in the model.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Starting values StartingValuesBSVARSV.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StartingValuesBSVARSV-get_starting_values"></a>}}
\if{latex}{\out{\hypertarget{method-StartingValuesBSVARSV-get_starting_values}{}}}
\subsection{Method \code{get_starting_values()}}{
Returns the elements of the starting values StartingValuesBSVARSV as a \code{list}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_starting_values_bsvar_sv$get_starting_values()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# starting values for a bsvar model with 1 lag for a 3-variable system
sv = specify_starting_values_bsvar_sv$new(N = 3, p = 1, T = 100)
sv$get_starting_values()   # show starting values as list

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StartingValuesBSVARSV-set_starting_values"></a>}}
\if{latex}{\out{\hypertarget{method-StartingValuesBSVARSV-set_starting_values}{}}}
\subsection{Method \code{set_starting_values()}}{
Returns the elements of the starting values StartingValuesBSVAR_SV as a \code{list}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_starting_values_bsvar_sv$set_starting_values(last_draw)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{last_draw}}{a list containing the last draw of the current MCMC run.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class StartingValuesBSVAR including the last draw of the current MCMC as the starting value to be passed to the continuation of the MCMC estimation using \code{estimate()}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# starting values for a bsvar model with 1 lag for a 3-variable system
sv = specify_starting_values_bsvar_sv$new(N = 3, p = 1, T = 100)

# Modify the starting values by:
sv_list = sv$get_starting_values()   # getting them as list
sv_list$A <- matrix(rnorm(12), 3, 4) # modifying the entry
sv$set_starting_values(sv_list)      # providing to the class object

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StartingValuesBSVARSV-clone"></a>}}
\if{latex}{\out{\hypertarget{method-StartingValuesBSVARSV-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_starting_values_bsvar_sv$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
