% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_draws.R
\name{as_draws_df.mcmc_output}
\alias{as_draws_df.mcmc_output}
\alias{as_draws}
\alias{as_draws_df}
\alias{as_draws.mcmc_output}
\title{Convert \code{run_mcmc} Output to \code{draws_df} Format}
\usage{
\method{as_draws_df}{mcmc_output}(x, times, states, ...)

\method{as_draws}{mcmc_output}(x, times, states, ...)
}
\arguments{
\item{x}{An object of class \code{mcmc_output}.}

\item{times}{A vector of indices defining which time points to return?
Default is all.}

\item{states}{A vector of indices defining which states to return.
Default is all.}

\item{...}{Ignored.}
}
\value{
A \code{draws_df} object.
}
\description{
Converts MCMC output from \code{run_mcmc} call to a
\code{draws_df} format of the \code{posterior} package. This enables the use
of diagnostics and plotting methods of \code{posterior} and \code{bayesplot}
packages.
}
\note{
The jump chain representation is automatically expanded by
\code{as_draws}, but if \code{run_mcmc} used IS-MCMC method, the output
contains additional \code{weight} column corresponding to the IS-weights
(without counts), which is ignored by \code{posterior} and \code{bayesplot},
i.e. those results correspond to approximate MCMC.
}
\examples{

model <- bsm_lg(Nile, 
  sd_y = tnormal(init = 100, mean = 100, sd = 100, min = 0),
  sd_level = tnormal(init = 50, mean = 50, sd = 100, min = 0),
  a1 = 1000, P1 = 500^2)

fit1 <- run_mcmc(model, iter = 2000)
draws <- as_draws(fit1)
head(draws, 4)
estimate_ess(draws$sd_y)
summary(fit1, return_se = TRUE)

# More chains:
model$theta[] <- c(50, 150) # change initial value
fit2 <- run_mcmc(model, iter = 2000, verbose = FALSE)
model$theta[] <- c(150, 50) # change initial value
fit3 <- run_mcmc(model, iter = 2000, verbose = FALSE)

# it is actually enough to transform first mcmc_output to draws object, 
# rest are transformed automatically inside bind_draws
draws <- posterior::bind_draws(as_draws(fit1),
  as_draws(fit2), as_draws(fit3), along = "chain")

posterior::rhat(draws$sd_y)

}
