% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{shiny_iconlink}
\alias{shiny_iconlink}
\title{Create link containing Shiny icon}
\usage{
shiny_iconlink(name = "info-circle", ...)
}
\arguments{
\item{name}{character, name of the icon, passed to \code{shiny::\link[shiny]{icon}}}

\item{...}{other arguments passed to \code{shiny::\link[shiny]{icon}}}
}
\value{
\code{htmltools::\link[htmltools]{tag}}, \code{<a/>}
}
\description{
You can use this helper function to wrap link element
around a \code{shiny::\link[shiny]{icon}}.
It may be useful to attach a modal window to
(or embed a popover into) into such a link.
}
\examples{
shiny_iconlink()

shiny_iconlink() \%>\%
  bs_embed_popover(title = "Help!", content = "I need somebody")

}
\seealso{
\code{\link{shinyInput_label_embed}},
  \code{shiny::\link[shiny]{icon}}, \code{\link{bs_attach_modal}},
  \code{\link{bs_embed_popover}}, \code{\link{bs_embed_tooltip}}
}

