% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bsc}
\alias{bsc}
\title{Basis matrix for B-spline of order 0 (step function) and higher}
\usage{
bsc(x, xk, n = 3L)
}
\arguments{
\item{x}{Numeric vector, abscissa points}

\item{xk}{Numeric vector, knots}

\item{n}{Integer scalar, polynomial order (3 by default)}
}
\value{
Numeric matrix, each column correspond to a B-spline calculated on x
}
\description{
This function is analogous but not equivalent to \code{splines:bs()} and \code{splines2::bSpline()}.
It is also several times faster.
}
\details{
For n==0, step function is defined as constant on each interval
  \code{[xk[i]; xk[i+1][}, i.e. closed on the left and open on the right
  except for the last interval which is closed on the right too.
}
\examples{
  x=seq(0, 5, length.out=101)
  # cubic basis matrix
  n=3
  m=bsc(x, xk=c(rep(0, n+1), 1:4, rep(5, n+1)), n=n)
  matplot(x, m, t="l")
  stopifnot(all.equal.numeric(c(m), c(splines::bs(x, knots = 1:4, degree = n, intercept = TRUE))))
}
\seealso{
{splines::bs()}, {splines2::bSpline()}
}
