% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notification_notification_count.R
\name{bs_get_notification_count}
\alias{bs_get_notification_count}
\title{Get the user's (self) number of unread notifications}
\usage{
bs_get_notification_count(
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass)
)
}
\arguments{
\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}
}
\value{
a tibble with a single column and row for the count
}
\description{
Get the user's (self) number of unread notifications
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/notification/getUnreadCount.json}{notification/getUnreadCount.json (2023-10-02)}
}

\section{Function introduced}{

\code{v0.0.1} (2023-10-02)
}

\examples{
\dontshow{if (has_bluesky_pass() & has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bs_get_notification_count()
\dontshow{\}) # examplesIf}
}
\concept{notification}
