% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ppc.R
\name{plot_ppc.bgmfit}
\alias{plot_ppc.bgmfit}
\alias{plot_ppc}
\title{Perform posterior predictive distribution checks}
\usage{
\method{plot_ppc}{bgmfit}(
  model,
  type,
  ndraws = NULL,
  draw_ids = NULL,
  prefix = c("ppc", "ppd"),
  group = NULL,
  x = NULL,
  newdata = NULL,
  resp = NULL,
  verbose = FALSE,
  deriv_model = NULL,
  dummy_to_factor = NULL,
  usesavedfuns = FALSE,
  clearenvfuns = NULL,
  envir = NULL,
  ...
)

plot_ppc(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{type}{Type of the ppc plot as given by a character string.
See \code{\link[bayesplot:PPC-overview]{PPC}} for an overview
of currently supported types. You may also use an invalid
type (e.g. \code{type = "xyz"}) to get a list of supported
types in the resulting error message.}

\item{ndraws}{A positive integer indicating the number of posterior draws to
be used in estimation. If \code{NULL} (default), all draws are used.}

\item{draw_ids}{An integer indicating the specific posterior draw(s)
to be used in estimation (default \code{NULL}).}

\item{prefix}{The prefix of the \pkg{bayesplot} function to be applied. 
Either `"ppc"` (posterior predictive check; the default)
or `"ppd"` (posterior predictive distribution), the latter being the same
as the former except that the observed data is not shown for `"ppd"`.}

\item{group}{Optional name of a factor variable in the model
by which to stratify the ppc plot. This argument is required for
ppc \code{*_grouped} types and ignored otherwise.}

\item{x}{Optional name of a variable in the model.
Only used for ppc types having an \code{x} argument
and ignored otherwise.}

\item{newdata}{An optional data frame to be used in estimation. If
\code{NULL} (default), the \code{newdata} is retrieved from the
\code{model}.}

\item{resp}{A character string (default \code{NULL}) to specify response
variable when processing posterior draws for the \code{univariate_by} and
\code{multivariate} models. See \code{\link[=bsitar]{bsitar()}} for details on
\code{univariate_by} and \code{multivariate} models}

\item{verbose}{An optional argument (logical, default \code{FALSE}) to
indicate whether to print information collected during setting up the
object(s).}

\item{deriv_model}{A logical to specify whether to estimate velocity curve
from the derivative function, or the differentiation of the distance curve.
The argument \code{deriv_model} is set to \code{TRUE} for those functions
which need velocity curve such as \code{growthparameters()} and
\code{plot_curves()}, and \code{NULL} for functions which explicitly use
the distance curve (i.e., fitted values) such as \code{loo_validation()}
and \code{plot_ppc()}.}

\item{dummy_to_factor}{A named list (default \code{NULL}) that is used to
convert dummy variables into a factor variable. The named elements are
\code{factor.dummy}, \code{factor.name}, and \code{factor.level}. The
\code{factor.dummy} is a vector of character strings that need to be
converted to a factor variable whereas the \code{factor.name} is a single
character string that is used to name the newly created factor variable.
The \code{factor.level} is used to name the levels of newly created factor.
When \code{factor.name} is \code{NULL}, then the factor name is internally
set as \code{'factor.var'}. If \code{factor.level} is \code{NULL}, then
names of factor levels are take from the \code{factor.dummy} i.e., the
factor levels are assigned same name as \code{factor.dummy}. Note that when
\code{factor.level} is not \code{NULL}, its length must be same as the
length of the \code{factor.dummy}.}

\item{usesavedfuns}{A logical (default \code{FALSE}) to indicate whether to
use the already exposed and saved \code{Stan} functions. This is for
internal purposes only and mainly used during the testing of the functions
and therefore should not be used by users as it might lead to unreliable
estimates.}

\item{clearenvfuns}{A logical to indicate whether to clear the exposed
function from the environment (\code{TRUE}) or not (\code{FALSE}). If
\code{NULL} (default), then \code{clearenvfuns} is set as \code{TRUE} when
\code{usesavedfuns} is \code{TRUE}, and \code{FALSE} if \code{usesavedfuns}
is \code{FALSE}.}

\item{envir}{Environment used for function evaluation. The default is
\code{NULL} which will set \code{parent.frame()} as default environment.
Note that since most of post processing functions are based on \pkg{brms},
the functions needed for evaluation should be in the \code{.GlobalEnv}.
Therefore, it is strongly recommended to set \code{ envir = globalenv()}
(or \code{envir = .GlobalEnv}). This is particularly true for the
derivatives such as velocity curve.}

\item{...}{Additional arguments passed to the \code{\link[brms:pp_check.brmsfit]{brms::pp_check.brmsfit()}}
function. Please see \code{\link[brms:pp_check.brmsfit]{brms::pp_check.brmsfit()}} for details.}
}
\value{
A ggplot object that can be further customized using the
ggplot2 package.
}
\description{
Perform posterior predictive checks with the help
of the \pkg{bayesplot} package.
}
\details{
The \strong{plot_ppc()} is a wrapper around the \code{\link[brms:pp_check.brmsfit]{brms::pp_check()}}.
}
\examples{

# Fit Bayesian SITAR model 

# To avoid mode estimation which takes time, a model fitted to the 
# 'berkeley_mdata' has already been saved as 'berkeley_mfit'. 
# Details on 'berkeley_mdata' and 'berkeley_mfit' are provided in the 
# 'bsitar' function.

model <- berkeley_mfit

plot_ppc(model, ndraws = 100)

}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
