% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsTools2.R
\name{bs_navbar}
\alias{bs_navbar}
\title{Create a Bootstrap navbar}
\usage{
bs_navbar(
  id = sampleStr(12, sample_chars = c(letters, LETTERS)),
  brand = list(),
  from_left = list(),
  from_right = list(),
  nav_attr = c(class = "navbar bg-primary navbar-dark navbar-expand-lg"),
  container_attr = c(class = "container-fluid"),
  div_attr = c(),
  brand_attr = c(class = "navbar-brand"),
  from_left_ul_attr = c(class = "navbar-nav me-auto"),
  from_right_ul_attr = c(class = "navbar-nav"),
  li_attr = c(class = "nav-item"),
  a_attr = c(class = "nav-link")
)
}
\arguments{
\item{id}{A string, used to control the collapse/expand functionality. Defaults to a random string.}

\item{brand}{A named list of length 1, name should be a value suitable for the href attribute of html5::a
and the value is the HTML or text to display in the a tag.}

\item{from_left}{A list, creates navbar elements arranged to the left. If a list item is named,
names should be links and values should be text to display in the navbar for that link. Names will be passed to the
href attribute and values to the main content of the html5::a function which will be wrapped by the html5::li function,
each of which have Bootstrap classes added by default. If an item in the list is not named, the item must be
valid HTML with appropriate Bootstrap classes added manually. For example, to add a drop-down, add an unnamed item to the list
with HTML defining the drop-down as the value of the item.}

\item{from_right}{A list, creates navbar elements arranged to the right. If a list item is named,
names should be links and values should be text to display in the navbar for that link. Names will be passed to the
href attribute and values to the main content of the html5::a function which will be wrapped by the html5::li function,
each of which have Bootstrap classes added by default. If an item in the list is not named, the item must be
valid HTML with appropriate Bootstrap classes added manually. For example, to add a drop-down, add an unnamed item to the list
with HTML defining the drop-down as the value of the item.}

\item{nav_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::nav.}

\item{container_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::div to be used as a container.}

\item{div_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::div wrapping the brand and left and right content.}

\item{brand_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::a containing the brand href and text.}

\item{from_left_ul_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::ul.}

\item{from_right_ul_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::ul.}

\item{li_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::li.}

\item{a_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::a.}
}
\value{
A string of HTML.
}
\description{
Learn more at \url{https://getbootstrap.com/docs/5.1/components/navbar/}.
}
\examples{
bs_navbar(
brand = list("#" = "Sample Brand"),
from_left = list(
  "/" = "Home",
  "/about" = "About"
),
from_right = list(
  "/options" = "Options"
)
)
}
