% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{bs4Stars}
\alias{bs4Stars}
\title{AdminLTE3 stars}
\usage{
bs4Stars(maxstar = 5, grade, status = "warning")
}
\arguments{
\item{maxstar}{Maximum number of stars by block.}

\item{grade}{Current score. Should be positive and lower or equal to maxstar.}

\item{status}{Star color: see \code{validColors()} in the documentation.}
}
\description{
Create a block of stars (ideal for rating)
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)
 
 shiny::shinyApp(
   ui = bs4DashPage(
     navbar = bs4DashNavbar(),
     sidebar = bs4DashSidebar(),
     controlbar = bs4DashControlbar(),
     footer = bs4DashFooter(),
     title = "test",
     body = bs4DashBody(
      bs4Card(
       title = "Stars",
       bs4Stars(grade = 5),
       bs4Stars(grade = 5, status = "success"),
       bs4Stars(grade = 1, status = "danger"),
       bs4Stars(grade = 3, status = "info")
      )
     )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
