% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multinomial_reg-fit.R
\name{brulee_multinomial_reg}
\alias{brulee_multinomial_reg}
\alias{brulee_multinomial_reg.default}
\alias{brulee_multinomial_reg.data.frame}
\alias{brulee_multinomial_reg.matrix}
\alias{brulee_multinomial_reg.formula}
\alias{brulee_multinomial_reg.recipe}
\title{Fit a multinomial regression model}
\usage{
brulee_multinomial_reg(x, ...)

\method{brulee_multinomial_reg}{default}(x, ...)

\method{brulee_multinomial_reg}{data.frame}(
  x,
  y,
  epochs = 20L,
  penalty = 0.001,
  mixture = 0,
  validation = 0.1,
  optimizer = "LBFGS",
  learn_rate = 1,
  momentum = 0,
  batch_size = NULL,
  class_weights = NULL,
  stop_iter = 5,
  verbose = FALSE,
  ...
)

\method{brulee_multinomial_reg}{matrix}(
  x,
  y,
  epochs = 20L,
  penalty = 0.001,
  mixture = 0,
  validation = 0.1,
  optimizer = "LBFGS",
  learn_rate = 1,
  momentum = 0,
  batch_size = NULL,
  class_weights = NULL,
  stop_iter = 5,
  verbose = FALSE,
  ...
)

\method{brulee_multinomial_reg}{formula}(
  formula,
  data,
  epochs = 20L,
  penalty = 0.001,
  mixture = 0,
  validation = 0.1,
  optimizer = "LBFGS",
  learn_rate = 1,
  momentum = 0,
  batch_size = NULL,
  class_weights = NULL,
  stop_iter = 5,
  verbose = FALSE,
  ...
)

\method{brulee_multinomial_reg}{recipe}(
  x,
  data,
  epochs = 20L,
  penalty = 0.001,
  mixture = 0,
  validation = 0.1,
  optimizer = "LBFGS",
  learn_rate = 1,
  momentum = 0,
  batch_size = NULL,
  class_weights = NULL,
  stop_iter = 5,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{Depending on the context:
\itemize{
\item A \strong{data frame} of predictors.
\item A \strong{matrix} of predictors.
\item A \strong{recipe} specifying a set of preprocessing steps
created from \code{\link[recipes:recipe]{recipes::recipe()}}.
}

The predictor data should be standardized (e.g. centered or scaled).}

\item{...}{Not currently used, but required for extensibility.}

\item{y}{When \code{x} is a \strong{data frame} or \strong{matrix}, \code{y} is the outcome
specified as:
\itemize{
\item A \strong{data frame} with 1 factor column (with three or more levels).
\item A \strong{matrix} with 1 factor column (with three or more levels).
\item A factor \strong{vector} (with three or more levels).
}}

\item{epochs}{An integer for the number of epochs of training.}

\item{penalty}{The amount of weight decay (i.e., L2 regularization).}

\item{mixture}{Proportion of Lasso Penalty (type: double, default: 0.0). A
value of mixture = 1 corresponds to a pure lasso model, while mixture = 0
indicates ridge regression (a.k.a weight decay).}

\item{validation}{The proportion of the data randomly assigned to a
validation set.}

\item{optimizer}{The method used in the optimization procedure. Possible choices
are 'LBFGS' and 'SGD'. Default is 'LBFGS'.}

\item{learn_rate}{A positive number that controls the rapidity that the model
moves along the descent path. Values around 0.1 or less are typical.
(\code{optimizer = "SGD"} only)}

\item{momentum}{A positive number usually on \verb{[0.50, 0.99]} for the momentum
parameter in gradient descent.  (\code{optimizer = "SGD"} only)}

\item{batch_size}{An integer for the number of training set points in each
batch.}

\item{class_weights}{Numeric class weights (classification only). The value
can be:
\itemize{
\item A named numeric vector (in any order) where the names are the outcome
factor levels.
\item An unnamed numeric vector assumed to be in the same order as the outcome
factor levels.
\item A single numeric value for the least frequent class in the training data
and all other classes receive a weight of one.
}}

\item{stop_iter}{A non-negative integer for how many iterations with no
improvement before stopping.}

\item{verbose}{A logical that prints out the iteration history.}

\item{formula}{A formula specifying the outcome term(s) on the left-hand side,
and the predictor term(s) on the right-hand side.}

\item{data}{When a \strong{recipe} or \strong{formula} is used, \code{data} is specified as:
\itemize{
\item A \strong{data frame} containing both the predictors and the outcome.
}}
}
\value{
A \code{brulee_multinomial_reg} object with elements:
\itemize{
\item \code{models_obj}: a serialized raw vector for the torch module.
\item \code{estimates}: a list of matrices with the model parameter estimates per
epoch.
\item \code{best_epoch}: an integer for the epoch with the smallest loss.
\item \code{loss}: A vector of loss values (MSE for regression, negative log-
likelihood for classification) at each epoch.
\item \code{dim}: A list of data dimensions.
\item \code{parameters}: A list of some tuning parameter values.
\item \code{blueprint}: The \code{hardhat} blueprint data.
}
}
\description{
\code{brulee_multinomial_reg()} fits a model.
}
\details{
This function fits a linear combination of coefficients and predictors to
model the log of the class probabilities. The training process optimizes the
cross-entropy loss function.

By default, training halts when the validation loss increases for at least
\code{step_iter} iterations. If \code{validation = 0} the training set loss is used.

The \emph{predictors} data should all be numeric and encoded in the same units (e.g.
standardized to the same range or distribution). If there are factor
predictors, use a recipe or formula to create indicator variables (or some
other method) to make them numeric. Predictors should be in the same units
before training.

The model objects are saved for each epoch so that the number of epochs can
be efficiently tuned. Both the \code{\link[=coef]{coef()}} and \code{\link[=predict]{predict()}} methods for this
model have an \code{epoch} argument (which defaults to the epoch with the best
loss value).

The use of the L1 penalty (a.k.a. the lasso penalty) does \emph{not} force
parameters to be strictly zero (as it does in packages such as \pkg{glmnet}).
The zeroing out of parameters is a specific feature the optimization method
used in those packages.
}
\examples{
if (torch::torch_is_installed()) {

  library(recipes)
  library(yardstick)

  data(penguins, package = "modeldata")

  penguins <- penguins \%>\% na.omit()

  set.seed(122)
  in_train <- sample(1:nrow(penguins), 200)
  penguins_train <- penguins[ in_train,]
  penguins_test  <- penguins[-in_train,]

  rec <- recipe(island ~ ., data = penguins_train) \%>\%
    step_dummy(species, sex) \%>\%
    step_normalize(all_predictors())

  set.seed(3)
  fit <- brulee_multinomial_reg(rec, data = penguins_train, epochs = 5)
  fit

  predict(fit, penguins_test) \%>\%
    bind_cols(penguins_test) \%>\%
    conf_mat(island, .pred_class)
}
}
\seealso{
\code{\link[=predict.brulee_multinomial_reg]{predict.brulee_multinomial_reg()}}, \code{\link[=coef.brulee_multinomial_reg]{coef.brulee_multinomial_reg()}},
\code{\link[=autoplot.brulee_multinomial_reg]{autoplot.brulee_multinomial_reg()}}
}
