% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predictive_prior.R
\name{Prior_x}
\alias{Prior_x}
\alias{dprior_x}
\alias{pprior_x}
\alias{qprior_x}
\alias{rprior_x}
\alias{sprior_x}
\title{Prior predictive distribution of the count in the treated group}
\usage{
dprior_x(x, a, b, c, d, T)

pprior_x(q, a, b, c, d, T)

qprior_x(p, a, b, c, d, T)

rprior_x(n, a, b, c, d, T)

sprior_x(a, b, c, d, T, ...)
}
\arguments{
\item{x,q}{vector of non-negative \strong{integer} quantiles}

\item{a,b}{non-negative shape parameter and rate parameter of the Gamma prior distribution on the rate \eqn{\mu}}

\item{c,d}{non-negative shape parameters of the prior distribution on \eqn{\phi}}

\item{T}{sample size of the control group}

\item{p}{vector of probabilities}

\item{n}{number of observations to be simulated}

\item{...}{passed to \code{\link{summary_PGB2}}}
}
\value{
\code{dprior_x} gives the density, \code{pprior_x} the distribution function,
\code{qprior_x} the quantile function, \code{rprior_x} samples from the distribution,
and \code{sprior_x} gives a summary of the distribution.
}
\description{
Density, distribution function, quantile function and random
generation for the prior predictive distribution of the count in the treated group.










}
\details{
The prior predictive distribution of the count \eqn{x} is the
\code{\link[=PGB2Dist]{Poisson-Gamma-Beta2 distribution}}
with shape parameters \eqn{a}, \eqn{d}, \eqn{c},
and hyperrate parameter \eqn{b/(b+T)}.
}
\note{
\code{Prior_x} is a generic name for the functions documented.
}
\examples{
barplot(dprior_x(0:30, 2, 3, 4, 5, 10))
sprior_x(2, 3, 4, 5, 10, output="pandoc")
}

