% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lme4_tidiers.R
\name{augment.ranef.mer}
\alias{augment.ranef.mer}
\title{Augmentation for random effects (for caterpillar plots etc.)}
\usage{
\method{augment}{ranef.mer}(x, ci.level = 0.9, reorder = TRUE,
  order.var = 1, ...)
}
\arguments{
\item{x}{ranef (conditional mode) information from an lme4 fit, using \code{ranef(.,condVar=TRUE)}}

\item{ci.level}{level for confidence intervals}

\item{reorder}{reorder levels by conditional mode values?}

\item{order.var}{numeric or character: which variable to use for ordering levels?}

\item{\dots}{additional arguments (unused: for generic consistency)}
}
\description{
Augmentation for random effects (for caterpillar plots etc.)
}
\examples{
if (require("lme4")) {
   load(system.file("extdata","lme4_example.rda",package="broom.mixed"))
   rr <- ranef(lmm1,condVar=TRUE)
   aa <- broom::augment(rr)
   ## Q-Q plot:
   if (require(ggplot2) && require(dplyr)) {
      g0 <- ggplot(aa,aes(estimate,qq,xmin=lb,xmax=ub))+
          geom_errorbarh(height=0)+
          geom_point()+facet_wrap(~variable,scale="free_x")
      ## regular caterpillar plot:
      g1 <- ggplot(aa,aes(estimate,level,xmin=lb,xmax=ub))+
         geom_errorbarh(height=0)+
         geom_vline(xintercept=0,lty=2)+
         geom_point()+facet_wrap(~variable,scale="free_x")
      ## emphasize extreme values
      aa2 <- aa  \%>\% group_by(grp,level) \%>\%
            mutate(keep=any(estimate/std.error>2))
       ## Update caterpillar plot with extreme levels highlighted
       ##  (highlight all groups with *either* extreme intercept *or*
       ##   extreme slope)
      ggplot(aa2,aes(estimate,level,xmin=lb,xmax=ub,colour=factor(keep)))+
         geom_errorbarh(height=0)+
         geom_vline(xintercept=0,lty=2)+
         geom_point()+facet_wrap(~variable,scale="free_x")+
         scale_colour_manual(values=c("black","red"), guide=FALSE)
   }
}
}
