% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_knots}
\alias{get_knots}
\title{Obtain the knots from a broken stick model}
\usage{
get_knots(
  object,
  hide = c("right", "left", "boundary", "internal", "none"),
  whatknots = "all",
  what = "all"
)
}
\arguments{
\item{object}{An object of class \code{brokenstick}}

\item{hide}{Should output for knots be hidden in get, print, summary and plot
functions? Can be \code{"left"}, \code{"right"}, \code{"boundary"}, \code{"internal"} or \code{"none"}.
The default is \code{"right"}.}

\item{whatknots}{Deprecated. Use \code{hide} instead.}

\item{what}{Deprecated. Use \code{hide} instead.}
}
\value{
A vector with knot locations, either both, internal only or
boundary only, depending on \code{hide}.
The result is \code{NULL} if \code{object} does not
have proper class. Returns \code{numeric(0)} if
there are no internal knots.
}
\description{
Obtain the knots from a broken stick model
}
\examples{
get_knots(fit_200, hide = "bo")
}
