% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula-helpers.R
\name{mm}
\alias{mm}
\title{Set up multi-membership grouping terms in \pkg{brms}}
\usage{
mm(..., weights = NULL)
}
\arguments{
\item{...}{One or more terms containing grouping factors.}

\item{weights}{A matrix specifying the weights of each member.
It should have as many columns as grouping terms specified in \code{...}.
Weights are standardized in order to sum to one per row.
If \code{NULL} (the default), equally weights are used.}
}
\description{
Function to set up a multi-membership grouping term in \pkg{brms}.
The function does not evaluate its arguments --
it exists purely to help set up a model with grouping terms.
}
\examples{
\dontrun{
# simulate some data
dat <- data.frame(y = rnorm(100), x = rnorm(100), 
                  g1 = sample(1:10, 100, TRUE),
                  g2 = sample(1:10, 100, TRUE))
# multi-membership model with two members per group and equal weights
fit1 <- brm(y ~ x + (1|mm(g1, g2)), data = dat)
summary(fit1)

# weight the first member two times for than the second member
dat$w1 <- rep(2, 100)
dat$w2 <- rep(1, 100)
fit2 <- brm(y ~ x + (1|mm(g1, g2, weights = cbind(w1, w2))), data = dat)
summary(fit2)
}
  
}
\seealso{
\code{\link[brms:brmsformula]{brmsformula}}
}

