% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R, R/generics.R
\name{bayes_factor.brmsfit}
\alias{bayes_factor.brmsfit}
\alias{bayes_factor}
\alias{bayes_factor}
\title{Bayes Factors from Marginal Likelihoods}
\usage{
\method{bayes_factor}{brmsfit}(x1, x2, log = FALSE, ...)

bayes_factor(x1, x2, ...)
}
\arguments{
\item{x1}{A \code{brmsfit} object}

\item{x2}{Another \code{brmsfit} object based on the same responses.}

\item{log}{Report Bayes factors on the log-scale?}

\item{...}{Additional arguments passed to 
\code{\link[brms:bridge_sampler]{bridge_sampler}}.}
}
\description{
Compute Bayes factors from marginal likelihoods.
}
\details{
Computing the marginal likelihood requires samples 
  of all variables defined in Stan's \code{parameters} block
  to be saved. Otherwise \code{bayes_factor} cannot be computed.
  Thus, please set \code{save_all_pars = TRUE} in the call to \code{brm},
  if you are planning to apply \code{bayes_factor} to your models.

  More details are provided under \code{\link[bridgesampling:bf]{bf}}.
}
\note{
The \code{bayes_factor} method is an alias of the
 \code{\link[bridgesampling:bf]{bf}} method provided by
 the \pkg{bridge_sampler} package. Using an alias
 is necessary, because the function name \code{bf}
 is already taken in \pkg{brms}.
}
\examples{
\dontrun{
# model with the treatment effect
fit1 <- brm(
  count ~ log_Age_c + log_Base4_c + Trt_c,
  data = epilepsy, family = negbinomial(), 
  prior = prior(normal(0, 1), class = b),
  save_all_pars = TRUE
)
summary(fit1)

# model without the treatment effect
fit2 <- brm(
  count ~ log_Age_c + log_Base4_c,
  data = epilepsy, family = negbinomial(), 
  prior = prior(normal(0, 1), class = b),
  save_all_pars = TRUE
)
summary(fit2)

# compute the bayes factor
bayes_factor(fit1, fit2)
}

}
\seealso{
\code{
  \link[brms:bridge_sampler]{bridge_sampler},
  \link[brms:post_prob]{post_prob}
}
}
