% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_marginal_data.R
\name{brm_marginal_data}
\alias{brm_marginal_data}
\title{Marginal summaries of the data.}
\usage{
brm_marginal_data(
  data,
  level = 0.95,
  use_subgroup = !is.null(attr(data, "brm_subgroup"))
)
}
\arguments{
\item{data}{A classed data frame from \code{\link[=brm_data]{brm_data()}}.}

\item{level}{Numeric of length 1 from 0 to 1, level of the confidence
intervals.}

\item{use_subgroup}{Logical of length 1, whether to summarize the data by
each subgroup level.}
}
\value{
A tibble with one row per summary statistic and the following
columns:
\itemize{
\item \code{group}: treatment group.
\item \code{subgroup}: subgroup level. Only included if the \code{subgroup}
argument of \code{\link[=brm_marginal_data]{brm_marginal_data()}} is \code{TRUE}.
\item \code{time}: discrete time point.
\item \code{statistic}: type of summary statistic.
\item \code{value}: numeric value of the estimate.
}

The \code{statistic} column has the following possible values:
\itemize{
\item \code{mean}: observed mean response after removing missing values.
\item \code{median}: observed median response after removing missing values.
\item \code{sd}: observed standard deviation of the response after
removing missing values.
\item \code{lower}: lower bound of a normal equal-tailed confidence interval
with confidence level determined by the \code{level} argument.
\item \code{upper}: upper bound of a normal equal-tailed confidence interval
with confidence level determined by the \code{level} argument.
\item \code{n_observe}: number of non-missing values in the response.
\item \code{n_total}: number of total records in the data for the given
group/time combination, including both observed and missing values.
}
}
\description{
Marginal summaries of the data.
}
\examples{
set.seed(0L)
data <- brm_data(
  data = brm_simulate_simple()$data,
  outcome = "response",
  role = "response",
  group = "group",
  time = "time",
  patient = "patient",
  reference_group = "group_1",
  reference_time = "time_1"
)
brm_marginal_data(data = data)
}
\seealso{
Other marginals: 
\code{\link{brm_marginal_draws}()},
\code{\link{brm_marginal_draws_average}()},
\code{\link{brm_marginal_probabilities}()},
\code{\link{brm_marginal_summaries}()}
}
\concept{marginals}
