#' Turtles Data from Janzen, Tucker, and Paukstis (2000)
#'
#' This data set contains information about 244 newborn turtles from 31 different clutches. For each turtle, the data set includes information about survival status (column \code{y}; 0 = died, 1 = survived), birth weight in grams (column \code{x}), and clutch (family) membership (column \code{clutch}; an integer between one and 31). The clutches have been ordered according to mean birth weight.
#'
#' @docType data
#' @keywords dataset
#' @name turtles
#' @usage turtles
#' @format A data.frame with 244 rows and 3 variables.
#' @source Janzen, F. J., Tucker,  J. K., & Paukstis, G. L. (2000). Experimental analysis of an early life-history stage: Selection on size of hatchling turtles. \emph{Ecology, 81(8)}, 2290-2304. \url{http://doi.org/10.2307/177115}
#'
#' Overstall, A. M., & Forster, J. J. (2010). Default Bayesian model determination methods for generalised linear mixed models. \emph{Computational Statistics & Data Analysis, 54}, 3269-3288. \url{http://dx.doi.org/10.1016/j.csda.2010.03.008}
#'
#' Sinharay, S., & Stern, H. S. (2005). An empirical comparison of methods for computing Bayes factors in generalized linear mixed models. \emph{Journal of Computational and Graphical Statistics, 14(2)}, 415-435. \url{http://dx.doi.org/10.1198/106186005X47471}
#' @encoding UTF-8
#'
#' @example examples/example.turtles.R
NULL
