% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmultinom.R
\name{predict.brmultinom}
\alias{predict.brmultinom}
\title{Predict method for \code{brmultinom} fits}
\usage{
\method{predict}{brmultinom}(object, newdata, type = c("class", "probs"), ...)
}
\arguments{
\item{object}{a fitted object of class inheriting from
\code{"brmultinom"}.}

\item{newdata}{optionally, a data frame in which to look for
variables with which to predict.  If omitted, the fitted linear
predictors are used.}

\item{type}{the type of prediction required. The default is
\code{"class"}, which produces predictions of the response
category at the covariate values supplied in \code{"newdata"},
selecting the category with the largest probability; the
alternative \code{"probs"} returns all cateogry probabilities
at the covariate values supplied in \code{"newdata"}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
If \code{type = "class"} a vector with the predicted response
categories; if \code{type = "probs"} a matrix of probabilities for
all response categories at \code{newdata}.
}
\description{
Obtain class and probability predictions from a fitted baseline
category logits model.
}
\details{
If \code{newdata} is omitted the predictions are based on the data
used for the fit.
}
\examples{

data("housing", package = "MASS")

# Maximum likelihood using brmultinom with baseline category 'Low'
houseML1 <- brmultinom(Sat ~ Infl + Type + Cont, weights = Freq,
                       data = housing, type = "ML", ref = 1)

# New data
newdata <- expand.grid(Infl = c("Low", "Medium"),
                       Type = c("Tower", "Atrium", "Terrace"),
                       Cont = c("Low", NA, "High"))

## Predictions
sapply(c("class", "probs"), function(what) predict(houseML1, newdata, what))

}
