% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rich_club.R
\name{rich_club_attrs}
\alias{rich_club_attrs}
\title{Assign graph attributes based on rich-club analysis}
\usage{
rich_club_attrs(g, deg.range = NULL, adj.vsize = FALSE)
}
\arguments{
\item{g}{An \code{igraph} graph object}

\item{deg.range}{Integer vector of the range of degrees indicating
inclusion in the rich-club; if the default \emph{NULL}, it will be from 1
to the maximum degree in the graph}

\item{adj.vsize}{Logical indicating whether to adjust vertex size
proportional to degree (default: FALSE)}
}
\value{
An \code{igraph} graph object with additional attributes:
  \item{rich}{Binary indicating membership in the rich-club}
  \item{type.rich}{Edge attribute indicating the type of connection}
  \item{color.rich}{Edge and vertex attributes}
  \item{size.rich}{Edge and vertex attributes}
}
\description{
This function will assign vertex- and edge-level attributes based on the
results of a \emph{rich-club} analysis, based on a range of vertex degrees in
which the rich-club coefficient was determined to be significantly greater
than that of a set of random graphs (see \code{\link{rich_club_norm}}).
}
\details{
Vertices which are in the rich club will be assigned an attribute
\code{rich}, taking on a binary value. Their colors (attribute
\code{color.rich}) will be either \emph{red} or \emph{gray}. Their sizes
(attribute \code{size.rich}) will either be 10 or will be proportional to
their degree.

Edge attribute \code{type.rich} takes on three values: \emph{rich-club} (if
it connects two rich-club vertices), \emph{feeder} (if it connects a rich- to
a non-rich-club vertex), and \emph{local} (if it connects two non-rich-club
vertices). They will also be given a \code{color.rich} attribute (either
\emph{red}, \emph{orange}, or \emph{green}). Edge sizes (\code{size.rich})
will be largest for \emph{rich-club} connections, then smaller for
\emph{feeder}, and smallest for \emph{local}.
}
\examples{
\dontrun{
g <- rich_club_attrs(g, rich.dt[density == densities[N] & p.fdr < .01,
                                range(k)])
}
}
\seealso{
Other Rich-club functions: \code{\link{RichClub}},
  \code{\link{plot_rich_norm}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{Rich-club functions}
