% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_rich_norm.R
\name{plot_rich_norm}
\alias{plot_rich_norm}
\title{Plot normalized rich club coefficients against degree threshold}
\usage{
plot_rich_norm(rich.dt, facet.by = c("density", "threshold"), densities,
  alpha = 0.05, fdr = TRUE, g = NULL, smooth = TRUE)
}
\arguments{
\item{rich.dt}{A \code{data.table} with rich-club coefficients}

\item{facet.by}{A character string indicating whether the variable of
interest is "density" or "threshold" (e.g. with DTI data)}

\item{densities}{A numeric vector of the densities to plot}

\item{alpha}{The significance level (default: 0.05)}

\item{fdr}{A logical, indicating whether or not to use the FDR-adjusted
p-value for determining significance (default: TRUE)}

\item{g}{A list (of lists) of \code{igraph} graph objects; required if you
want to plot a shaded region demarcating the \code{\link{rich_core}}}

\item{smooth}{Logical indicating whether or not to use
\code{\link[ggplot2]{stat_smooth}} when data from multiple subjects (per
group) are present (default: \code{TRUE}). Ignored for group-level data.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object
}
\description{
Returns a \code{\link[ggplot2]{ggplot}} object of a line plot of the
normalized rich club coefficient. Optionally will include a shaded region
demarcating the \code{\link{rich_core}} cutoff (if you supply a list of graph
objects to the \code{g} argument).
}
\examples{
\dontrun{
plot_rich_norm(rich.dt, facet.by='density', densities[N:(N+1)], g=g)
}
}
\seealso{
Other Rich-club functions: \code{\link{RichClub}},
  \code{\link{rich_club_attrs}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{Rich-club functions}
