% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtpc.R
\name{mtpc}
\alias{mtpc}
\alias{summary.mtpc}
\alias{plot.mtpc}
\title{Multi-threshold permutation correction}
\usage{
mtpc(g.list, thresholds, covars, measure, contrasts, con.type = c("t",
  "f"), outcome = NULL, con.name = NULL, level = c("vertex",
  "graph"), clust.size = 3L, perm.method = c("freedmanLane",
  "terBraak", "smith"), part.method = c("beckmann", "guttman",
  "ridgway"), N = 500L, perms = NULL, alpha = 0.05, res.glm = NULL,
  long = TRUE, ...)

\method{summary}{mtpc}(object, contrast = NULL, digits = max(3L,
  getOption("digits") - 2L), print.head = TRUE, ...)

\method{plot}{mtpc}(x, contrast = 1L, region = NULL,
  only.sig.regions = TRUE, show.null = TRUE, caption.stats = FALSE,
  ...)
}
\arguments{
\item{g.list}{A list of \code{brainGraphList} objects for all thresholds}

\item{thresholds}{Numeric vector of the thresholds applied to the raw
connectivity matrices.}

\item{covars}{A \code{data.table} of covariates}

\item{measure}{Character string of the graph measure of interest}

\item{contrasts}{Numeric matrix specifying the contrast(s) of interest; if
only one contrast is desired, you can supply a vector}

\item{con.type}{Character string; either \code{'t'} or \code{'f'} (for t or
F-statistics). Default: \code{'t'}}

\item{outcome}{Character string specifying the name of the outcome variable,
if it differs from the graph metric (\code{measure})}

\item{con.name}{Character vector of the contrast name(s); if \code{contrasts}
has row names, those will be used for reporting results}

\item{level}{Character string; either \code{vertex} (default) or
\code{graph}}

\item{clust.size}{Integer indicating the size of \dQuote{clusters} (i.e.,
consecutive thresholds for which the observed statistic exceeds the null)
(default: \code{3L})}

\item{perm.method}{Character string indicating the permutation method.
Default: \code{'freedmanLane'}}

\item{part.method}{Character string; the method of partitioning the design
matrix into covariates of interest and nuisance. Default: \code{beckmann}}

\item{N}{Integer; number of permutations to create. Default: \code{5e3}}

\item{perms}{Matrix of permutations, if you would like to provide your own.
Default: \code{NULL}}

\item{alpha}{Numeric; the significance level. Default: 0.05}

\item{res.glm}{A list of \code{bg_GLM} objects, as output by a previous run
of \code{mtpc}. Useful if you want to change the cluster size without
re-running all of the GLM's and permutations (default: \code{NULL})}

\item{long}{Logical indicating whether or not to return all permutation
results. Default: \code{FALSE}}

\item{...}{Other arguments passed to \code{\link{brainGraph_GLM}} and/or
\code{\link{brainGraph_GLM_design}}}

\item{object, x}{A \code{mtpc} object}

\item{contrast}{Integer specifying the contrast to plot/summarize; defaults
to showing results for all contrasts}

\item{digits}{Integer specifying the number of digits to display for P-values}

\item{print.head}{Logical indicating whether or not to print only the first
and last 5 rows of the statistics tables (default: \code{TRUE})}

\item{region}{Character string specifying which region's results to
plot; only relevant if \code{level='vertex'}. Default: \code{NULL}}

\item{only.sig.regions}{Logical indicating whether to plot only significant
regions (default: \code{TRUE})}

\item{show.null}{Logical indicating whether to plot points of the maximum
null statistics (per permutation)}

\item{caption.stats}{Logical indicating whether to print the MTPC statistics
in the caption of the plot (default: \code{FALSE})}
}
\value{
An object of class \code{mtpc} with some input arguments plus the
  following elements:
  \item{res.glm}{List with length equal to the number of thresholds; each
    list element is the output from \code{\link{brainGraph_GLM}}}
  \item{DT}{A \code{data.table} for all thresholds, combined from the outputs
    of \code{\link{brainGraph_GLM}}}
  \item{stats}{A data.table containing \code{S.mtpc} (the max. observed
    statistic), \code{tau.mtpc} (the threshold of the max. observed
    statistic), \code{S.crit} (the critical statistic value), and
    \code{A.crit} (the critical AUC)}
  \item{null.dist}{Numeric matrix with \code{N} rows and number of columns
    equal to the number of thresholds. Each element is the maximum statistic
    for that permutation and threshold.}
  \item{perm.order}{Numeric matrix; the permutation set applied for all
    thresholds (each row is a separate permutation)}

The \code{plot} method returns a \emph{list} of
  \code{\link[ggplot2]{ggplot}} objects
}
\description{
Applies the \emph{multi-threshold permutation correction (MTPC)} method to
perform inference in graph theory analyses of brain MRI data.

Plot the statistics from an MTPC analysis, along with the maximum permuted
statistics. The output is similar to Figure 11 in Drakesmith et al. (2015).
}
\details{
This is a multi-step procedure: (steps 3-4 are the time-consuming steps)
\enumerate{
  \item Apply thresholds \eqn{\tau} to the networks, and compute network
    metrics for all networks and thresholds. (already done beforehand)
  \item Compute test statistics \eqn{S_{obs}} for each threshold. (done by
    \code{\link{brainGraph_GLM}})
  \item Permute group assignments and compute test statistics for each
    permutation and threshold. (done by \code{\link{brainGraph_GLM}})
  \item Build a null distribution of the maximum statistic across thresholds
    (and across brain regions) for each permutation. (done by
    \code{\link{brainGraph_GLM}})
  \item Determine the critical value, \eqn{S_{crit}} from the null
    distribution of maximum statistics.
  \item Identify clusters where \eqn{S_{obs} > S_{crit}} and compute the AUC
    for these clusters (denoted \eqn{A_{MTPC}}).
  \item Compute a critical AUC (\eqn{A_{crit}}) from the mean of the
    supra-critical AUC's for the permuted tests.
  \item Reject \eqn{H_0} if \eqn{A_{MTPC} > A_{crit}}.
}
}
\examples{
\dontrun{
diffs.mtpc <- mtpc(g.list=g.norm, thresholds=thresholds, N=N,
     covars=covars.dti, measure='E.nodal.wt', coding='effects',
     contrasts=c(0, 0, 0, 0, -2), alt='greater',
     binarize=c('Sex', 'Scanner'), con.name='Group 1 > Group 2')
sig.regions <- diffs.mtpc$DT[A.mtpc > A.crit]
}
\dontrun{
mtpcPlots <- plot(mtpc.diffs)

## Arrange plots into 3x3 grids
ml <- marrangeGrob(mtpcPlots, nrow=3, ncol=3)
ggsave('mtpc.pdf', ml)
}
}
\references{
Drakesmith, M. and Caeyenberghs, K. and Dutt, A. and Lewis, G. and
  David, A.S. and Jones, D.K. (2015) Overcoming the effects of false
  positives and threshold bias in graph theoretical analyses of neuroimaging
  data. \emph{NeuroImage}, \bold{118}, 313--333.
  \url{https://dx.doi.org/10.1016/j.neuroimage.2015.05.011}
}
\seealso{
Other Group analysis functions: \code{\link{Bootstrapping}},
  \code{\link{GLM}}, \code{\link{Mediation}},
  \code{\link{NBS}}, \code{\link{brainGraph_permute}}

Other GLM functions: \code{\link{GLM design}},
  \code{\link{GLM fits}}, \code{\link{GLM}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{GLM functions}
\concept{Group analysis functions}
