% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_rich_norm.R
\name{plot_rich_norm}
\alias{plot_rich_norm}
\title{Plot normalized rich club coefficients against degree threshold}
\usage{
plot_rich_norm(rich.dt, facet.by = c("density", "threshold"), densities,
  alpha = 0.05, fdr = TRUE, g = NULL)
}
\arguments{
\item{rich.dt}{A \code{data.table} with rich-club coefficients}

\item{facet.by}{A character string indicating whether the variable of
interest is "density" or "threshold" (e.g. with DTI data)}

\item{densities}{A numeric vector of the densities to plot}

\item{alpha}{The significance level (default: 0.05)}

\item{fdr}{A logical, indicating whether or not to use the FDR-adjusted
p-value for determining significance (default: TRUE)}

\item{g}{A list (of lists) of \code{igraph} graph objects; required if you
want to plot a shaded region demarcating the \code{\link{rich_core}}}
}
\value{
A \code{\link[ggplot2]{ggplot}} object
}
\description{
Returns a \code{\link[ggplot2]{ggplot}} object of a line plot of the normalized rich club
coefficient for up to two subject groups. Optionally will include a shaded
region demarcating the \code{\link{rich_core}} cutoff.
}
\examples{
\dontrun{
plot_rich_norm(rich.dt, facet.by='density', densities[N:(N+1)], g=g)
}
}
\seealso{
Other Rich-club functions: \code{\link{RichClub}},
  \code{\link{rich_club_attrs}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
