% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_brainGraph.R
\name{plot.brainGraph_mediate}
\alias{plot.brainGraph_mediate}
\title{Plot a graph with results from a mediation analysis}
\usage{
\method{plot}{brainGraph_mediate}(x, subgraph = "p.acme > 0.95",
  main = sprintf("\\n\\n\\nEffect of \\"\%s\\" on\\n\\"\%s\\"\\nmediated by \\"\%s\\"",
  x$treat, x$outcome, x$mediator), subt = NULL, cex.main = 1, ...)
}
\arguments{
\item{x}{An graph object (from \code{\link{make_mediate_brainGraph}})}

\item{subgraph}{Character string specifying an equation for vertices to plot
(default: \code{NULL})}

\item{main}{Character string; the main title (default: \code{NULL})}

\item{subt}{Character string; the subtitle (default: \code{default})}

\item{cex.main}{Numeric indicating the scaling for plot title size (see
\code{\link[graphics]{par}}.}

\item{...}{Other parameters (passed to \code{\link[igraph]{plot.igraph}}).
See \code{\link[igraph]{igraph.plotting}} for details.}
}
\description{
Plot a graph with results from a mediation analysis
}
\seealso{
Other Plotting functions: \code{\link{plot.brainGraph_GLM}},
  \code{\link{plot.brainGraph_NBS}},
  \code{\link{plot.brainGraph_mtpc}},
  \code{\link{plot.brainGraph}},
  \code{\link{plot_brainGraph_gui}},
  \code{\link{plot_brainGraph_list}},
  \code{\link{plot_brainGraph_multi}}
}
