% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vulnerability.R
\name{vulnerability}
\alias{vulnerability}
\title{Calculate graph vulnerability}
\usage{
vulnerability(g, use.parallel = TRUE, weighted = FALSE)
}
\arguments{
\item{g}{An \code{igraph} graph object}

\item{use.parallel}{Logical indicating whether or not to use \emph{foreach}
(default: \code{TRUE})}

\item{weighted}{Logical indicating whether weighted efficiency should be
calculated (default: \code{FALSE})}
}
\value{
A numeric vector of length equal to the vertex count of \emph{g}
}
\description{
This function calculates the \emph{vulnerability} of the vertices of a graph.
Here, vulnerability is considered to be the proportional drop in global
efficiency when a given node is removed from the graph. The vulnerability of
the graph is considered the maximum across all vertices.
}
\references{
Latora V., Marchiori M. (2005) \emph{Variability and protection
of infrastructure networks}. Physical Review E, 71:015103.
}
\seealso{
\code{\link{efficiency}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
