% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brainGraph_GLM.R
\name{brainGraph_GLM_fit}
\alias{brainGraph_GLM_fit}
\title{Fit linear models and calculate statistics}
\usage{
brainGraph_GLM_fit(X, y, con.vec, alpha = 0.05, alternative = c("two.sided",
  "less", "greater"))
}
\arguments{
\item{X}{The design matrix}

\item{y}{Numeric vector of the outcome variable}

\item{con.vec}{Numeric vector of the contrast of interest}

\item{alpha}{Numeric; the significance level (default: 0.05)}

\item{alternative}{Character string for the alternative hypothesis (default:
\code{'two.sided'})}
}
\value{
A list containing:
  \item{gamma}{The contrast of parameter estimates}
  \item{se}{The standard error}
  \item{t.stat}{The t-statistic}
  \item{p.val}{The p-value}
  \item{ci.low}{The lower confidence limit}
  \item{ci.high}{The upper confidence limit}
}
\description{
This function is partly a wrapper for \code{\link[RcppEigen]{fastLmPure}},
fitting a linear model and return the contrast of parameter estimates,
standard error, t-statistic, and p-value (given a contrast of interest).
}
\details{
For speed purposes (if it is called from
\code{\link[brainGraph]{brainGraph_GLM}} and permutation testing is done),
this function does not do argument checking.
}
\seealso{
Other GLM functions: \code{\link{brainGraph_GLM_design}},
  \code{\link{brainGraph_GLM}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
