% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ursaModel.R
\name{fitUrsaModel}
\alias{fitUrsaModel}
\alias{fitUrsaModel.formula}
\alias{fitUrsaModel.default}
\title{URSA Response Surface Fitting}
\usage{
fitUrsaModel(
  formula,
  data,
  weights = NULL,
  direction = 0,
  lower = NULL,
  upper = NULL
)

\method{fitUrsaModel}{formula}(
  formula,
  data,
  weights = NULL,
  direction = 0,
  lower = NULL,
  upper = NULL
)

\method{fitUrsaModel}{default}(
  formula,
  data,
  weights = NULL,
  direction = 0,
  lower = NULL,
  upper = NULL
)
}
\arguments{
\item{formula}{Either an object of class \code{formula} such as would be provided
to a modeling function like \code{\link[stats:lm]{stats::lm()}}, or a width-2 numeric array vector
of concentration pairs (including 0 or Inf).  A formula should specify a
single output as a function of two inputs, eg. \code{activity ~ conc1 + conc2}.}

\item{data}{If \code{forumula} is a symbolic formula, a data frame containing the
specified values. If \code{formula} is a numeric array of concentrations, a
numeric vector of response values, the same length as the number of rows of
\code{formula}.}

\item{weights}{A vector of weights (between 0 and 1) the same length as
the data which determines the weight with which each measurement
will impact the the sum of squared errors.  Weights will be multiplied by
errors \emph{before} squaring.  If \code{NULL} (the default) all weights will be set
to 1. Can be a numeric vector, or the name of a column in \code{data} if \code{formula}
is a symbolic formula}

\item{direction}{Determines the possible directionality of the BRAID
model.  If 0 (the default) no additional constraints are placed on the
parameters.  If greater than 0, the fitting will require that the maximal
effects are all \emph{greater} than or equal to the minimal effect.  If less
than 0, the fitting will require that all maximal effect is \emph{less} than or
equal to the minimal effect.}

\item{lower}{An optional set of lower bounds on the seven URSA response
parameters.  Any values set to NA will be filled with default calculated
bounds.}

\item{upper}{An optional set of upper bounds on the seven URSA response
parameters.  Any values set to NA will be filled with default calculated
bounds.}
}
\value{
An object of class \code{braidAltFit} with the following values:
\itemize{
\item \code{concs}: The array of concentrations passed to the functions
\item \code{act}: The vector of measurements associated with the given dose pairs
\item \code{weights}: The vector of weights for the given measurements, set to 1 for
all measurements by default
\item \code{method}: Specifying the alternate surface model being used (in this case
"URSA")
\item \code{coefficients}: A length-seven parameter vector specifying the URSA
response surface
\item \code{fitted.values}: The predicted response surface value for the given dose
pairs and best-fit response surface
\item \code{residuals}: The difference between the predicted and measured values for
the given dose pairs, always equal to "measured minus predicted"
\item \code{direction}: The direction value passed to the function
\item \code{pbounds}': A 2-by-7 array of bounds on the URSA parameters used in the
parameter optimization
}
}
\description{
Fits the universal response surface approach (URSA) model to the given
data (Greco, Park, and Rustum 1990)
}
\examples{
ufit1 <- fitUrsaModel(measure ~ concA + concB, additiveExample)
coef(ufit1)

ufit2 <- fitUrsaModel(measure ~ concA + concB, synergisticExample,
                      direction = 1, lower=c(NA, NA, NA, NA, NA, 0, 0))
coef(ufit2)
}
\references{
Greco, William R, Hyoung Sook Park, and Youcef M Rustum. 1990.
“Application of a New Approach for the Quantitation of Drug Synergism to
the Combination of Cis-Diamminedichloroplatinum and
1-b-d-Arabinofuranosylcytosine.” \emph{Cancer Research} \strong{50} (17): 5318–27.
}
