% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classfunctions.R
\name{coef_ran}
\alias{coef_ran}
\title{Random effect variances}
\usage{
coef_ran(object, type = "linear")
}
\arguments{
\item{object}{an object used to select a method.}

\item{type}{one of \code{c("linear", "circular")} to get either the linear or
circular random effect variances.}
}
\description{
\code{coef_ran} gives posterior summaries of the circular or linear random
effect variances.
}
\details{
the method \link[bpnreg]{coef_ran.bpnme} has its own help page.
}
\examples{
library(bpnreg)
fit.Maps <- bpnme(pred.I = Error.rad ~ Maze + Trial.type + L.c + (1|Subject),
data = Maps,
its = 100, burn = 1, n.lag = 1)
coef_ran(fit.Maps)
coef_ran(fit.Maps, type = "circular")


}
