% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpc_exports.R
\name{get_sample_posterior}
\alias{get_sample_posterior}
\title{Get the posterior samples for a parameter of the model.}
\usage{
get_sample_posterior(bpc_object, par = "lambda", n = 1000)
}
\arguments{
\item{bpc_object}{a bpc object}

\item{par}{name of the parameters to predict}

\item{n}{how many times are we sampling? Default 1000}
}
\value{
Return a data frame with the posterior samples for the parameters. One column for each parameter one row for each sample
}
\description{
Return a data frame with the posterior samples for the parameters of the model
}
\examples{
\donttest{
m<-bpc(data = tennis_agresti,
player0 = 'player0',
player1 = 'player1',
result_column = 'y',
model_type = 'bt',
solve_ties = 'none')
s <- get_sample_posterior(m, par='lambda', n=100)
print(head(s))
}
}
