% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bootLR.R
\name{run.BayesianLR.test}
\alias{run.BayesianLR.test}
\title{The actual function that runs the test. BayesianLR.test is a wrapper that runs this with ever-looser tolerances.}
\usage{
run.BayesianLR.test(truePos, totalDzPos, trueNeg, totalDzNeg, R = 10^4,
  verbose = FALSE, parameters = list(shrink = 5, tol = 5e-04, nEach = 80),
  ci.width = 0.95, consistentQuantile = 0.5, ...)
}
\arguments{
\item{truePos}{The number of true positive tests.}

\item{totalDzPos}{The total number of positives ("sick") in the population.}

\item{trueNeg}{The number of true negatives in the population.}

\item{totalDzNeg}{The total number of negatives ("well") in the population.}

\item{R}{is the number of replications in each round of the bootstrap (has been tested at 10,000 or greater).}

\item{verbose}{Whether to display internal operations as they happen.}

\item{parameters}{List of control parameters (shrink, tol, nEach) for sequential grid search.}

\item{ci.width}{The width of the confidence interval used by boot.ci (not necessarily the same as the width of the CI produced by the algorithm overall; if this parameter is changed, results are not tested)}

\item{consistentQuantile}{Defaults to 0.5, i.e. the median. Finds the lowest probability for which the random draws are likely to be consistently one, where consistently is defined by this value (i.e. at .5, a simple majority of the time is enough for consistency). Changing this parameter results in different properties than have been tested and is not recommended.}

\item{\dots}{Arguments to pass along to boot.ci for the BCa confidence intervals.}
}
\value{
An object of class lrtest.
}
\description{
The actual function that runs the test. BayesianLR.test is a wrapper that runs this with ever-looser tolerances.
}

