% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootImpute.R
\name{bootImputeAnalyse}
\alias{bootImputeAnalyse}
\title{Analyse bootstrapped and imputed estimates}
\usage{
bootImputeAnalyse(imps, analysisfun, nCores = 1, quiet = FALSE, ...)
}
\arguments{
\item{imps}{The list of imputed datasets returned by \code{\link{bootImpute}}}

\item{analysisfun}{A function which when applied to a single dataset returns
the estimate of the parameter(s) of interest. The dataset to be analysed
is passed to \code{analysisfun} as its first argument.}

\item{nCores}{The number of CPU cores to use. If specified greater than one,
\code{bootImputeAnalyse} will impute using the number of cores specified. The
number of bootstrap samples in \code{imps} should be divisible by \code{nCores}.}

\item{quiet}{Specify whether to print a table of estimates, confidence intervals
and p-values.}

\item{...}{Other parameters that are to be passed through to \code{analysisfun}.}
}
\value{
A vector containing the point estimate(s), variance estimates, and
degrees of freedom.
}
\description{
Applies the user specified analysis function to each imputed dataset contained
in \code{imps}, then calculates estimates, confidence intervals and p-values
for each parameter, as proposed by von Hippel and Bartlett (2019).
}
\details{
Multiple cores can be used by using the \code{nCores} argument, which may be
useful for reducing computation times.
}
\examples{
library(mice)

set.seed(564764)

#bootstrap twice and impute each twice
#in practice you should bootstrap many more times, e.g. at least 200
imps <- bootMice(ex_linquad, nBoot=2, nImp=2)

#analyse estimates
#write a wapper to analyse an imputed dataset
analyseImp <- function(inputData) {
  coef(lm(y~z+x+xsq,data=inputData))
}
ests <- bootImputeAnalyse(imps, analyseImp)
}
\references{
von Hippel PT, Bartlett JW. Maximum likelihood multiple imputation: faster,
more efficient imputation without posterior draws. arXiv, 2019, 1210.0870v10
 \url{https://arxiv.org/pdf/1210.0870v10.pdf}
}
