% Generated by roxygen2 (4.0.0): do not edit by hand
\name{arcfsReweighter}
\alias{arcfsReweighter}
\title{Reweighter for the arc-fs algorithm.}
\usage{
arcfsReweighter(prediction, response, weights, ...)
}
\arguments{
\item{prediction}{a vector of predictions.}

\item{response}{a vector whose \eqn{i^{th}}{ith} component is the true
response for the \eqn{i^{th}}{ith} component of \code{prediction}.}

\item{weights}{a vector of weights. They don't necessarily need to sum to 1.}

\item{...}{implemented to allow reweighter to accept its output as its input.}
}
\value{
For internal bookkeeping, this function is inherits from the
'\code{reweighter}' class. It returns a named list with components
\item{weights}{the updated weights calculated from the input weights,
\code{prediction} and \code{response}.}

\item{beta}{scalar weights to be used by \code{\link{arcfsAggregator}}.}
}
\description{
A slightly modified implementation of the reweighter described in
the arc-fs algorithm.
}
\details{
As per Leo Breiman's suggestions, a slight modification to the arc-fs
algorithm has been made in the case where \eqn{\epsilon}{\epsilon} -- the misclassification
measure -- exceed 0.5, or becomes 0. Should this happen \eqn{\beta}{\beta} is
set to \eqn{-\infty}{-\infty} and  a warning is produced. At this point
you are advised to restart the algorithm with equal probabilities or stop
boosting, at that iteration.
}
\seealso{
Other arc-fs: \code{\link{arcfsAggregator}}

Other reweighters: \code{\link{adaboostReweighter}};
  \code{\link{arcx4Reweighter}}; \code{\link{boost}},
  \code{\link{boost.function}}, \code{\link{boost.list}};
  \code{\link{vanillaBagger}}
}

