% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BN-methods.R
\name{dag.to.cpdag}
\alias{dag.to.cpdag}
\title{convert a DAG to a CPDAG}
\usage{
dag.to.cpdag(dag.adj.matrix, layering = NULL, layer.struct = NULL)
}
\arguments{
\item{dag.adj.matrix}{the adjacency matrix representing the DAG of a \code{\link{BN}}.}

\item{layering}{vector containing the layers where each node belongs.}

\item{layer.struct}{layer.struct \code{0/1} matrix for indicating which layers can contain parent nodes
for nodes in a layer (only for \code{mmhc}, \code{mmpc}).}
}
\value{
the adjacency matrix representing a CPDAG for the network.
}
\description{
Convert the adjacency matrix representing the DAG of a \code{\link{BN}}
into the adjacency matrix representing a CPDAG for the network.
}
\examples{
\dontrun{
net <- learn.network(dataset, layering=layering, layer.struct=layer.struct)
pdag <- dag.to.cpdag(dag(net), layering, layer.struct)
wpdag(net) <- pdag
}

}
\seealso{
\code{\link{wpdag.from.dag}}
}
