% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gera.pa.R
\name{gera.pa}
\alias{gera.pa}
\title{Generates a model as input to execute a Path Analysis (PA).}
\usage{
gera.pa(bn.averaged, data.to.work, pa.name, pa.imgname)
}
\arguments{
\item{bn.averaged}{is a Bayesian Network structure learned from data.}

\item{data.to.work}{is a data frame containing the variables of the BN.}

\item{pa.name}{is a variable to store the name of file to save Path Analysis parameters.}

\item{pa.imgname}{is a variable to store the name of file to save Path Analysis graph.}
}
\value{
pa.model.fit an object of class lavaan.
}
\description{
Builds a model as input to Path Analysis from a Bayesian Network (BN) learned.
}
\details{
This function receives a Bayesian Networks structure and a dataset, calculates 
the correlation matrix from data, scan all columns of dataset, scan all parents 
of each column variable and build a Path Analysis model string. Then run the Path Analysis model 
using Strucutural Equation Model functions and export a Path Analysis graph figure with 
'semPaths' function and also export a Path Analysis model summary information.
}
\examples{
# Clean environment
closeAllConnections()
rm(list=ls())
# Load packages
library(bnpa)
library(bnlearn)
# load datasets from package
data.to.work<-dataQuantC # Pre-Loaded
# Learn Bayesian Networks structure
bn.structure <- hc(data.to.work)
# Set the name of a doc to save Path Analysis parameters
pa.name = "docPAHC"
# Set the name of an image with Path Analysis graph
pa.imgname = "imgPAHC"
# Generates the Path Analysis model from Bayesian Networks structure
pa.model.fit <- gera.pa(bn.structure, data.to.work, pa.name, pa.imgname)
}
\author{
Elias Carvalho
}

