% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standard.R
\name{mean_var}
\alias{mean_var}
\title{Standard variation of the mean vector}
\usage{
mean_var(gbn, entry, delta)
}
\arguments{
\item{gbn}{object of class \code{GBN}.}

\item{entry}{an index specifying the entry of the mean vector to vary.}

\item{delta}{additive variation coefficient for the entry of the mean vector given in \code{entry}.}
}
\value{
An object of class \code{GBN} with an updated mean vector.
}
\description{
Computation of an updated \code{GBN} object after a variation of the mean vector.
}
\details{
Let the original Bayesian network have a Normal distribution \eqn{\mathcal{N}(\mu,\Sigma)} and let \code{entry} be equal to \eqn{i}. Let \eqn{\mu_i} be the i-th entry of \eqn{\mu}. For a variation of the mean  by an amount \eqn{\delta} the resulting distribution is \eqn{\mathcal{N}(\mu',\Sigma)}, where \eqn{\mu'} is equal to \eqn{\mu} except for the i-th entry which is equal to \eqn{\mu+\delta}.
}
\examples{
mean_var(synthetic_gbn,2,3)

}
\references{
Gómez-Villegas, M. A., Maín, P., & Susi, R. (2007). Sensitivity analysis in Gaussian Bayesian networks using a divergence measure. Communications in Statistics—Theory and Methods, 36(3), 523-539.

Gómez-Villegas, M. A., Main, P., & Susi, R. (2013). The effect of block parameter perturbations in Gaussian Bayesian networks: Sensitivity and robustness. Information Sciences, 222, 439-458.
}
\seealso{
\code{\link{covariance_var}}
}
