% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{isolate}
\alias{isolate}
\title{Create isolated within- (and optionally between-) person variables.}
\usage{
isolate(d = NULL, by = NULL, value = NULL, z = FALSE,
  which = "within")
}
\arguments{
\item{d}{A \code{data.frame}.}

\item{by}{A vector of values in \code{d} by which the data is clustered.
i.e. a vector of unique participant IDs.}

\item{value}{Names of columns in \code{d} to isolate. Multiple values can be
given by \code{value = c("var1", "var2", "var3")}}

\item{z}{Should the created values be standardized (defaults to FALSE).}

\item{which}{Which component to return. "within" (default) returns
within-person deviations only; "between" returns between-person means only;
"both" returns both.}
}
\value{
A \code{data.frame} with additional columns for the within- and
between-person variables. The new columns are labelled _cw for
centered-within and _cb for centered-between.
}
\description{
Creates variables that represent pure within- and between-person predictors.
}
\examples{
# Create within-person deviations of work stressors in BLch9.
data(BLch9)
BLch9 <- isolate(BLch9, by = "id", value = "fwkstrs")
head(BLch9)  # Now has new column for within-person work stressors.

}
\author{
Matti Vuorre \email{mv2521@columbia.edu}
}
