\name{bma.bart}
\alias{bma.bart}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Bayesian Mediation Analysis Using Bayesian Additive Regression Trees
}
\description{
Build BARTs using the R package and perform the Bayesian Mediation Analysis.
}
\usage{
bma.bart(pred, m, y, refy = rep(NA, ncol(data.frame(y))), 
         predref = rep(NA, ncol(data.frame(pred))), deltap = NA, 
         deltam = NA, mref = rep(NA, ncol(data.frame(m))), cova = NULL, 
         cova.ref = list(), mcov = NULL, mcov.ref = list(), mclist = NULL, 
         complete = FALSE, ntree = 200L, numcut = 100L, ndpost = 1000L, 
         nskip = 100L, keepevery = 1L, nkeeptrain = ndpost, nkeeptest = ndpost,
         nkeeptestmean = ndpost, nkeeptreedraws = ndpost, printevery = 100L, 
         seed = sample(1:1e+06, 1))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{pred}{
The vector/matrix of the exposure/predict variable(s).
}
  \item{m}{
The dataframe of all potential mediators
}
  \item{y}{
The vector/matrix of the outcome(s).
}
  \item{refy}{
The reference groups of y when the corresponding outcome is binary or categorical.
}
  \item{predref}{
The reference groups of pred when the corresponding outcome is binary or categorical.
}
  \item{deltap}{
A vector of the length of the number of exposures. The difference in pred when calculate the changing rate by pred. If not set, the difference is 1 for categorical predictor and one tenth of the standard deviaiton of the predictor if continuous.
}
  \item{deltam}{
A vector of the length of the number of mediators. The ith item is the difference in the ith mediator when calculate the changing rate by each mediator. If not set, the difference is 1 for categorical mediators and one tenth of the standard deviaiton of the mediator if continuous.
}
  \item{mref}{
The reference groups of mediators when the corresponding mediator is binary or categorical.
}
  \item{cova}{
The covariance data for y.
}
  \item{cova.ref}{
The reference group for the binary or categorical covariates in cova.
}
  \item{mcov}{
The covariance data for mediators.
}
  \item{mcov.ref}{
The reference group if the mcovs are categorical or binary.
}
  \item{mclist}{
If mclist is null but not mcov, mcov is applied to all mediators.
If both mcov and mclist are not NULL, the first item of mclist lists all mediators that are using different mcov, the following items gives the mcov for the mediators in order, NA if no mcov to be used. e.g. mclist=list(c(1,2,4),l1=1,l2=NA,l4=c(1,3)), mediator 1, m[,1], use mcov[,1], 2 uses no covariates, 4 uses mcov[,c(1,3)], all other mediators use all. Can also replace variable names with column numbers in the mclist.
}
  \item{complete}{
complete=TRUE if only completed cases are used in analysis.
}
  \item{ntree}{
As in the BART package, the number of trees in the sum.
}
  \item{numcut}{
See the BART package. The number of possible values of c (see usequants). If a single number if given, this is used for all variables. Otherwise a vector with length equal to ncol(x.train) is required, where the ith element gives the number of c used for the ith variable in x.train. If usequants is false, numcut equally spaced cutoffs are used covering the range of values in the corresponding column of x.train. If usequants is true, then min(numcut, the number of unique values in the corresponding columns of x.train - 1) c values are used. 
}
  \item{ndpost}{
As in the BART package, the number of posterior draws returned.
}
  \item{nskip}{
As in the BART package, number of MCMC iterations to be treated as burn in.
}
  \item{keepevery}{
As in the BART package, every keepevery draw is kept to be returned to the user.
}
  \item{nkeeptrain}{
As in the BART package, number of MCMC iterations to be returned for train data.
}
  \item{nkeeptest}{
As in the BART package, number of MCMC iterations to be returned for test data. 
}
  \item{nkeeptestmean}{
As in the BART package, number of MCMC iterations to be returned for test mean.
}
  \item{nkeeptreedraws}{
As in the BART package, number of MCMC iterations to be returned for tree draws.
}
  \item{printevery}{
As in the BART package, as the MCMC runs, a message is printed every printevery draws.
}
  \item{seed}{
A seed number to keep the results repeatable.
}
}
\details{
Please refer to the reference for the details of model fitting and inferences of mediation effects.
}
\value{
\item{aieX }{posterior samples of average indirect effects using method X. method 2 to show the results from the partial differences, method 3 to show the results from the G-computation, and method 4 for G-computation with non-parametric method (binary exposures only).}
\item{adeX }{posterior samples of average direct effects using method X.}
\item{ateX }{posterior samples of average total effects using method X.}
\item{ieX, deX, teX}{posterior samples of indirect effects, direct effects and total effects using method X.}
\item{apart.ie}{posterior samples of the a-part:changing rate of mediators with pred, using method 2.}
\item{bpart.ie}{posterior samples of the b-part:changing rate of outcomes with mediators, using method 2.}
\item{data0}{the output from data_org.}
\item{y.type}{the type of outcomes.}
\item{y.model}{the BART model of outcomes.}
\item{m.models}{the BART model of each mediator.}
\item{DIC}{the estimated DIC,deviances, D_bar, Var_D, and p_D.}
}
\references{
Yu, Q., and Li, B. (2025) <doi:>. "Mediation Analysis with Bayesian Additive Regression Trees," submitted.
}
\author{
Qingzhao Yu and Bin Li
}
\note{
data_org is run automatically in bma.bart. No need to run it separately.
}

\examples{
data(weight_behavior)
#nubmer of mcmc iterations are set to 3 to reduce time. Need to bring it up to reasonable times.
#binary predictor
try0= bma.bart(pred=weight_behavior[,3], m=weight_behavior[,c(2,4:14)], 
               y=weight_behavior[,15], refy = 0, predref = "F",nskip=0,ndpost=2)
summary(try0)
\donttest{
#add covariate for mediators
try1= bma.bart(pred=weight_behavior[,3], m=weight_behavior[,c(2,4:13)], 
               mcov=weight_behavior[,14], mclist=append(list(var=1:10),rep(NA,10)), 
               #"sweater" is used as a cov for "excercises" only
               y=weight_behavior[,15], refy = 0, predref = "F",nskip=0,ndpost=2)  
summary(try1)
summary(try1,trim=0)
#multiple prdictor
try2= bma.bart(pred=weight_behavior[,4], m=weight_behavior[,c(2:3,5:14)], 
               y=weight_behavior[,15], refy = 0, predref = "OTHER",nskip=0,ndpost=2)
summary(try2)
try3= bma.bart(pred=weight_behavior[,c(1,4)], m=weight_behavior[,c(2:3,5:14)], 
               y=weight_behavior[,15], refy = 0, predref = "OTHER",nskip=0,ndpost=2)
summary(try3)
#continuous y
try4= bma.bart(pred=weight_behavior[,4], m=weight_behavior[,c(2:3,5)], 
               y=weight_behavior[,1], refy = 0, predref = "OTHER",nskip=0,ndpost=2)
summary(try4)
#categorical y
try5= bma.bart(pred=weight_behavior[,1], m=weight_behavior[,c(2:3,5)], 
               y=weight_behavior[,4], refy = "",nskip=0,ndpost=2)
summary(try5)
#add covariates for y and for mediators
try6= bma.bart(pred=weight_behavior[,4], m=weight_behavior[,c(5:12)], 
               cova=weight_behavior[,2:3], mcov=weight_behavior[,13:14], 
               mclist=c(list(var=1:7),rep(NA,6),list(1)),
               y=weight_behavior[,1], refy = 0, predref = "OTHER",nskip=0,ndpost=2)
#cova and mcov needs to be binarized and numerized
summary(try6)

##Surv class outcome (survival analysis)
data(cgd1)       #a dataset in the survival package
x=cgd1[,c(4:5,7:12)]
pred=cgd1[,6]
status<-ifelse(is.na(cgd1$etime1),0,1)
y=Surv(cgd1$futime,status)          
#for continuous predictor
try7= bma.bart(pred=pred,m=x,y=y,nskip=0,ndpost=3)
#summary(try7)
}
}
\keyword{ Bayesian Mediation Analysis }
\keyword{ Mediator Tests }