% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bls_request.R
\name{bls_request}
\alias{bls_request}
\title{Retrieve Data From the U.S. Bureau Of Labor Statistics API v2}
\usage{
bls_request(query, api_key = NA, user_agent = "http://github.com/groditi/blsR")
}
\arguments{
\item{query}{list generated by one of the query generating functions}

\item{api_key}{string, only necessary for retrieving multiple series in one
request, requesting calculations, or custom time frames and catalog data}

\item{user_agent}{string, optional}
}
\value{
a list of information returned by the API request
}
\description{
\code{bls_request()}  will execute queries against the BLS API. Queries are
generated using one of the following query-generating functions:
\code{\link[=query_series]{query_series()}}, \code{\link[=query_n_series]{query_n_series()}}, \code{\link[=query_popular_series]{query_popular_series()}},
\code{\link[=query_all_surveys]{query_all_surveys()}}, \code{\link[=query_survey_info]{query_survey_info()}}, \code{\link[=query_latest_observation]{query_latest_observation()}}.
The result is the "Results" block as defined in the API v2 signatures at
\url{https://www.bls.gov/developers/api_signature_v2.htm}
}
\examples{
\dontrun{
library(blsR)
uer_query <- query_series('LNS14000000') #monthly unemployment rate series
uer_results <- bls_request(uer_query) #API response
}
}
\seealso{
Other blsR-requests: 
\code{\link{get_all_surveys}()},
\code{\link{get_latest_observation}()},
\code{\link{get_n_series_table}()},
\code{\link{get_n_series}()},
\code{\link{get_popular_series}()},
\code{\link{get_series_tables}()},
\code{\link{get_series_table}()},
\code{\link{get_series}()},
\code{\link{get_survey_info}()}
}
\concept{blsR-requests}
