% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeMixtureSummaries.R
\name{OverallRiskSummaries}
\alias{OverallRiskSummaries}
\title{Calculate overall risk summaries}
\usage{
OverallRiskSummaries(fit, y = NULL, Z = NULL, X = NULL, qs = seq(0.25,
  0.75, by = 0.05), q.fixed = 0.5, preds.method = "approx", sel = NULL)
}
\arguments{
\item{fit}{An object containing the results returned by a the \code{kmbayes} function}

\item{y}{a vector of outcome data of length \code{n}.}

\item{Z}{an \code{n}-by-\code{M} matrix of predictor variables to be included in the \code{h} function. Each row represents an observation and each column represents an predictor.}

\item{X}{an \code{n}-by-\code{K} matrix of covariate data where each row represents an observation and each column represents a covariate. Should not contain an intercept column.}

\item{qs}{vector of quantiles at which to calculate the overall risk summary}

\item{q.fixed}{a second quantile at which to compare the estimated \code{h} function}

\item{preds.method}{method for obtaining posterior summaries at a vector of new point. Currently only implemented for \code{preds.method = "approx"}}

\item{sel}{logical expression indicating samples to keep; defaults to keeping the second half of all samples}
}
\description{
Compare estimated \code{h} function when all predictors are at a particular quantile to when all are at a second fixed percentile
}

