% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_resize.R
\name{bm_resize}
\alias{bm_resize}
\alias{bm_resize.bm_bitmap}
\alias{bm_resize.bm_list}
\alias{bm_resize.bm_pixmap}
\alias{bm_resize.magick-image}
\alias{bm_resize.nativeRaster}
\alias{bm_resize.raster}
\title{Resize bitmaps by trimming and/or extending}
\usage{
bm_resize(
  x,
  value,
  width = NULL,
  height = NULL,
  hjust = "center-left",
  vjust = "center-top"
)

\method{bm_resize}{bm_bitmap}(
  x,
  value = 0L,
  width = NULL,
  height = NULL,
  hjust = "center-left",
  vjust = "center-top"
)

\method{bm_resize}{bm_list}(x, ...)

\method{bm_resize}{bm_pixmap}(
  x,
  value = col2hex("transparent"),
  width = NULL,
  height = NULL,
  hjust = "center-left",
  vjust = "center-top"
)

\method{bm_resize}{`magick-image`}(
  x,
  value = "transparent",
  width = NULL,
  height = NULL,
  hjust = "center-left",
  vjust = "center-top"
)

\method{bm_resize}{nativeRaster}(
  x,
  value = col2int("transparent"),
  width = NULL,
  height = NULL,
  hjust = "center-left",
  vjust = "center-top"
)

\method{bm_resize}{raster}(
  x,
  value = "transparent",
  width = NULL,
  height = NULL,
  hjust = "center-left",
  vjust = "center-top"
)
}
\arguments{
\item{x}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_font]{bm_font()}}, \code{\link[=bm_list]{bm_list()}}, \link[magick:editing]{"magick-image"}, "nativeRaster", \code{\link[=bm_pixmap]{bm_pixmap()}}, or \link[grDevices:as.raster]{"raster"}  object.}

\item{value}{Value for the new pixels.}

\item{width}{How many pixels wide should the new bitmap be.
Use with the \code{hjust} argument or just one of either the \code{left} or \code{right} arguments.}

\item{height}{How many pixels tall should the new bitmap be.
Use with the \code{vjust} argument or just one of either the \code{top} or \code{bottom} arguments.}

\item{hjust}{One of "left", "center-left", "center-right", "right".
"center-left" and "center-right" will attempt to
place in "center" if possible but if not possible will bias
it one pixel left or right respectively.
"centre", "center", and "centre-left" are aliases for "center-left".
"centre-right" is an alias for "center-right".}

\item{vjust}{One of "bottom", "center-bottom", "center-top", "top".
"center-bottom" and "center-top" will attempt to
place in "center" if possible but if not possible will bias
it one pixel down or up respectively.
"centre", "center", and "centre-top" are aliases for "center-top".
"centre-bottom" is an alias for "center-bottom".}

\item{...}{Additional arguments to be passed to or from methods.}
}
\value{
Depending on \code{x} either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_font]{bm_font()}}, \code{\link[=bm_list]{bm_list()}}, \link[magick:editing]{magick-image}, "nativeRaster", \code{\link[=bm_pixmap]{bm_pixmap()}}, or \link[grDevices:as.raster]{raster}  object.
}
\description{
Trim and/or extend bitmaps to a desired height and/or width.
}
\details{
This function is a convenience wrapper around \code{\link[=bm_trim]{bm_trim()}} and \code{\link[=bm_extend]{bm_extend()}}.
}
\examples{
font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
font <- read_hex(font_file)
# add a border to an "R"
capital_r <- font[[str2ucp("R")]]
print(capital_r)
capital_r <- bm_resize(capital_r, width = 12L, height = 12L, vjust = "top")
print(capital_r)
corn <- farming_crops_16x16()$corn$portrait
corn_rs <- bm_resize(corn, width = 20L, height = 20L, vjust = "top")
if (cli::is_utf8_output() && cli::num_ansi_colors() >= 256L) {
  print(corn_rs, bg = "cyan", compress = "v")
}
}
\seealso{
\code{\link[=bm_extend]{bm_extend()}}, \code{\link[=bm_pad]{bm_pad()}}, and \code{\link[=bm_trim]{bm_trim()}}.
}
