% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.bm_bitmap.R
\docType{data}
\name{print.bm_bitmap}
\alias{print.bm_bitmap}
\alias{format.bm_bitmap}
\alias{px_unicode}
\alias{px_ascii}
\title{Print bitmap objects}
\format{
An object of class \code{character} of length 20.

An object of class \code{character} of length 20.
}
\usage{
\method{print}{bm_bitmap}(x, ..., px = getOption("bittermelon.px", px_unicode),
                                 fg = getOption("bittermelon.fg", FALSE),
                                 bg = getOption("bittermelon.bg", FALSE),
                                 compress = getOption("bittermelon.compress", "none"))

\method{format}{bm_bitmap}(x, ..., px = getOption("bittermelon.px", px_unicode),
                                 fg = getOption("bittermelon.fg", FALSE),
                                 bg = getOption("bittermelon.bg", FALSE),
                                 compress = getOption("bittermelon.compress", "none"))

px_unicode

px_ascii
}
\arguments{
\item{x}{A \code{bm_bitmap()} object}

\item{...}{Further arguments passed to or from other methods.}

\item{px}{Character vector of the pixel to use for each integer value i.e.
The first character for integer \code{0L},
the second character for integer \code{1L}, and so on.
Will be recycled.}

\item{fg}{R color strings of foreground colors to use.
Requires suggested package \code{crayon}.
\code{FALSE} (default) for no foreground colors.
Will be recycled.}

\item{bg}{R color strings of background colors to use.
Requires suggested package \code{crayon}.
\code{FALSE} (default) for no background colors.
Will be recycled.}

\item{compress}{If \code{none} (default) don't compress first with \code{\link[=bm_compress]{bm_compress()}}.
Otherwise compress first with \code{\link[=bm_compress]{bm_compress()}} passing
the value of \code{compress} as its \code{direction} argument
(i.e. either "vertical" or "v", "horizontal" or "h",
OR "both" or "b").}
}
\value{
A character vector of the string representation (\code{print.bm_bitmap()} does this invisibly).
As a side effect \code{print.bm_bitmap()} prints out the string representation to the terminal.
}
\description{
\code{print.bm_bitmap()} prints a representation of bitmap objects to the terminal.
It is a wrapper around \code{format.bm_bitmap()} which converts bitmap objects
to a character vector.
\code{px_unicode} and \code{px_ascii} are builtin character vectors intended for use with the \code{px}
argument (the former contains Unicode \dQuote{Block Elements} while the latter is purely ASCII).
}
\examples{
  font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
  font <- read_hex(font_file)
  bm_R <- font[[str2ucp("R")]]
  print(bm_R, px = c(" ", "#"))

  bm_8 <- font[[str2ucp("8")]]
  bm_8_with_border <- bm_extend(bm_extend(bm_8, left = 1L),
                                sides = 1L, value = 2L)
  print(bm_8_with_border, px = c(".", "@", "X"))

  if (require("crayon") && crayon::has_color()) {
    print(bm_8_with_border, px = " ", bg = c("white", "blue", "red"))
  }
}
\seealso{
\code{\link[=bm_bitmap]{bm_bitmap()}}
}
\keyword{datasets}
