% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trades.R
\name{tn_trades}
\alias{tn_trades}
\title{Individual trade data (testnet)}
\usage{
tn_trades(
  symbol = "XBTUSD",
  count = 1000,
  reverse = "true",
  filter = NULL,
  columns = NULL,
  start = NULL,
  startTime = NULL,
  endTime = NULL,
  use_auth = FALSE
)
}
\arguments{
\item{symbol}{a character string for the instrument symbol.
Use \code{\link[=available_symbols]{available_symbols()}} to see available symbols.}

\item{count}{an optional integer to specify the number of rows to return.
Maximum of 1000 (the default) per request.}

\item{reverse}{an optional character string. Either \code{"true"} of \code{"false"}.
If \code{"true"}, result will be ordered with starting with the newest (defaults to \code{"true"}).}

\item{filter}{an optional character string for table filtering.
Send JSON key/value pairs, such as \code{"{'key':'value'}"}. See examples.}

\item{columns}{an optional character vector of column names to return.
If \code{NULL}, all columns will be returned.}

\item{start}{an optional integer. Can be used to specify the starting point for results.}

\item{startTime}{an optional character string.
Starting date for results in the format \code{"yyyy-mm-dd"} or \code{"yyyy-mm-dd hh-mm-ss"}.}

\item{endTime}{an optional character string.
Ending date for results in the format \code{"yyyy-mm-dd"} or \code{"yyyy-mm-dd hh-mm-ss"}.}

\item{use_auth}{logical. Use \code{TRUE} to enable authentication with API key.}
}
\description{
\code{tn_trades()} retrieves data regarding individual trades that have been executed on the
testnet exchange.
}
\examples{
\dontrun{
# Return 1000 most recent trades for symbol "XBTUSD".
tn_trades(symbol = "XBTUSD")

# Use filter for very specific values: Return trade data executed at 12:15.
tn_trades(
  symbol = "XBTUSD",
  filter = "{'timestamp.minute':'12:15'}"
)

# Also possible to combine more than one filter.
tn_trades(
  symbol = "XBTUSD",
  filter = "{'timestamp.minute':'12:15', 'size':10000}"
)
}

}
\references{
\url{https://testnet.bitmex.com/api/explorer/#!/Trade/Trade_get}
}
\concept{tn_map_trades}
