% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birp_data.R
\name{birp_data_from_data_frame}
\alias{birp_data_from_data_frame}
\title{Creating a Birp Data Object based on dataframe(s)}
\usage{
birp_data_from_data_frame(data)
}
\arguments{
\item{data}{A single dataframe or a list of data frames (one per method). Each dataframe should consist of five columns: timepoint, location, counts, effort and CI_group. The rows of the dataframe correspond to the counts and efforts obtained at one particular timepoint, location and for one particular control-intervention (CI) group.}
}
\value{
An object of type \link{birp_data}
}
\description{
This function creates a birp_data object
}
\examples{
df <- data.frame(
  timepoint = 1:10,
  location = rep(1, 10),
  counts = runif(10, 0, 100),
  effort = rexp(10),
  CI_group = "intervention"
)
data <- birp_data_from_data_frame(df)
}
