% Generated by roxygen2 (4.0.2): do not edit by hand
\name{seq2ngrams}
\alias{seq2ngrams}
\title{Extract N-Grams From Sequence}
\usage{
seq2ngrams(seq, n, u, d = 0)
}
\arguments{
\item{seq}{\code{integer} vector or matrix describing sequence(s).}

\item{n}{\code{integer} size of n-gram.}

\item{u}{unigrams (\code{integer}, \code{numeric} or \code{character} vector).}

\item{d}{\code{integer} vector of distances between elements of n-gram (0 means
consecutive elements). See Details.}
}
\value{
A \code{character} matrix of n-grams, where every row corresponds to a
different sequence.
}
\description{
Extracts vector of n-grams present in sequence(s).
}
\details{
A format of \code{d} vector is discussed in Details of
\code{\link{count_ngrams}}.
}
\examples{
#trigrams from multiple sequences
seqs <- matrix(sample(1L:4, 600, replace = TRUE), ncol = 50)
seq2ngrams(seqs, 3, 1L:4)
}

