% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_night.R
\name{check_night}
\alias{check_night}
\alias{check_night.default}
\alias{check_night.vp}
\alias{check_night.list}
\alias{check_night.vpts}
\alias{check_night.pvol}
\title{Check if it is night at a given time and place}
\usage{
check_night(x, ..., elev = -0.268)

\method{check_night}{default}(x, lon, lat, ..., tz = "UTC", elev = -0.268)

\method{check_night}{vp}(x, ..., elev = -0.268)

\method{check_night}{list}(x, ..., elev = -0.268)

\method{check_night}{vpts}(x, ..., elev = -0.268)

\method{check_night}{pvol}(x, ..., elev = -0.268)
}
\arguments{
\item{x}{\code{pvol}, \code{vp} or \code{vpts},
or a date inheriting from class \code{POSIXct} or a string
interpretable by \link{as.POSIXct}.}

\item{...}{optional lat,lon arguments.}

\item{elev}{numeric. Sun elevation in degrees.}

\item{lon}{numeric. Longitude in decimal degrees.}

\item{lat}{numeric. Latitude in decimal degrees.}

\item{tz}{character. Time zone. Ignored when \code{date} already has an associated time zone}
}
\value{
\code{TRUE} when night, \code{FALSE} when day, \code{NA} if unknown
(either datetime or geographic location missing). For \code{vpts} a
vector of \code{TRUE}/\code{FALSE} values is returned.
}
\description{
Checks if it is night (\code{TRUE}/\code{FALSE}) for a combination of
latitude, longitude, date and sun elevation. When used on a bioRad object
(\code{pvol}, \code{vp}, \code{vpts}) this information is extracted from the
bioRad object directly.
}
\details{
The angular diameter of the sun is about 0.536 degrees, therefore
the moment of sunrise/sunset corresponds to half that elevation at
-0.268 degrees.

\code{check_night()} evaluates to \code{FALSE} when the sun has a higher
elevation than parameter \code{elev}, otherwise \code{TRUE}.

Approximate astronomical formula are used, therefore the day/night
transition may be off by a few minutes.
}
\examples{
# check if it is night at UTC midnight in the Netherlands on January 1st:
check_night("2016-01-01 00:00", 5, 53)

# check on bioRad objects directly:
check_night(example_vp)

check_night(example_vpts)
}
