% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpts.R
\name{summary.vpts}
\alias{summary.vpts}
\alias{print.vpts}
\alias{is.vpts}
\alias{dim.vpts}
\alias{[.vpts}
\title{Inspect a time series of vertical profiles (\code{vpts})}
\usage{
\method{summary}{vpts}(object, ...)

\method{print}{vpts}(x, digits = max(3L, getOption("digits") - 3L), ...)

is.vpts(x)

\method{dim}{vpts}(x)

\method{[}{vpts}(x, i)
}
\arguments{
\item{object}{A \code{vpts} object.}

\item{...}{Additional arguments affecting the summary produced.}

\item{x}{A \code{vpts} object.}

\item{digits}{The number of significant digits to use when printing. Defaults to \code{max(3L, getOption("digits") - 3L)}.}

\item{i}{Integer. Index/indices specifying which range of vertical profiles
to extract.}
}
\value{
For \code{\link[=summary.vpts]{summary.vpts()}}: prints the summary of the\code{vpts} object.

For \code{\link[=print.vpts]{print.vpts()}}: prints the summary of the \code{vpts} object.

For \code{\link[=is.vpts]{is.vpts()}}: \code{TRUE} for an object of class \code{vpts}, otherwise
\code{FALSE}.

For \code{\link[=dim.vpts]{dim.vpts()}}: number of datetimes, heights and quantities in a
time series of vertical profiles (\code{vpts}).

For \verb{[.vpts}: A \code{vpts} object containing a subset of vertical profiles (\code{vp}) or a
\code{vp} object when subsetting a single vertical profile (\code{vp}).
}
\description{
R base functions for inspecting a time series of vertical profiles (\code{vpts})
object.

Select a vertical profile (\code{vp}) or a time series of vertical profiles
(\code{vpts}) by index from a \code{vpts}.
}
\details{
A time series of vertical profiles contains time-ordered vertical profiles
(\verb{vp)} of a single radar. This time series can be \strong{regular} (\code{vp} are
equally spaced in time) or \strong{irregular} (time steps between \code{vp} are of
unequal length), indicated in the field \code{regular}. Irregular time series can
be projected onto a regular time grid with \code{\link[=regularize_vpts]{regularize_vpts()}}. A time series
of vertical profile (\code{vp}) object is a list containing:
\itemize{
\item \code{radar}: Radar identifier.
\item \code{datetime}: Nominal times of the profiles (named \code{dates} in bioRad <
0.4.0) in UTC.
\item \code{height}: Lowest height of the height bins in the profiles in m above sea
level.
\item \code{daterange}: Minimum and maximum nominal time of the profiles in UTC.
\item \code{timesteps}: Time differences between the profiles. Element \code{i} gives the
difference between profile \code{i} and \code{i+1}.
\item \code{data}: A list of quantities, each containing a \code{datetime} by \code{height}
matrix with the values. Use \code{\link[=get_quantity]{get_quantity()}} to access these and see
\code{\link[=summary.vp]{summary.vp()}} for a description of available quantities.
\item \code{attributes}: List of the vertical profile's \code{what}, \code{where}, and \code{how}
attributes, copied from the first profile.
\item \code{regular}: Logical indicating whether the time series is regular or not.
}
}
\section{Conventions}{

\itemize{
\item \code{NA}: Maps to \code{nodata} in the ODIM convention: value to denote areas void
of data (never radiated).
\item \code{NaN}: Maps to \code{undetect} in the ODIM convention: denote areas below the
measurement detection threshold (radiated but nothing detected). The value is
also used when there are too few datapoints to calculate a quantity.
\item \code{0}: Maps to \code{0} in the ODIM convention: denote areas where the quantity
has a measured value of zero (radiated and value zero detected or inferred).
}
}

\examples{
# Check if an object is of class vpts
is.vpts(example_vpts)

# Get summary info
example_vpts # Same as summary(example_vpts) or print(example_vpts)

# Get dimensions
dim(example_vpts)
# The example vpts contains 1934 profiles (i.e. datetimes)
dim(example_vpts)

# Subset vpts to extract 10th profile
example_vpts[10] # A vp object

# Subset vpts to extract the 20th to 100th profile
example_vpts[20:100] # A vpts object with 81 profiles

# Subset vpts to remove the first 10 profiles
example_vpts[-1:-10] # A vpts object with 10 less profiles
}
\seealso{
\itemize{
\item \code{\link[=bind_into_vpts]{bind_into_vpts()}}
\item \code{\link[=read_vpts]{read_vpts()}}
\item \code{\link[=filter_vpts]{filter_vpts()}}
\item \code{\link[=regularize_vpts]{regularize_vpts()}}
\item \code{\link{example_vpts}}
\item \code{\link[=get_quantity]{get_quantity()}}
\item \code{\link[=plot.vp]{plot.vp()}}
\item \code{\link[=as.data.frame.vpts]{as.data.frame.vpts()}}
\item \code{\link[=[.vpts]{[vpts()}}
}
}
