% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binspp_auxiliary.R
\name{print_outputs}
\alias{print_outputs}
\title{Text output describing the posterior distributions}
\usage{
print_outputs(Output)
}
\arguments{
\item{Output}{list, output of the main function \code{\link[=estintp]{estintp()}}.}
}
\value{
Text output summarizing the posterior distributions.
}
\description{
The summaries of the posterior distributions in the text form
are provided.
}
\details{
The parameter estimates (sample medians
from the empirical posterior distributions) and the 2.5\%
and 97.5\% quantiles from the empirical posterior
distributions are printed. \cr
Additionally, during the run of the MCMC chain the significance
of the covariates in the list \emph{z_beta} with respect to the
current population of parent points is repeatedly tested.
This function prints the medians of the series of p-values
obtained in this way, together with the corresponding
2.5\% and 97.5\% sample quantiles of the p-values for each covariate.
}
\examples{

library(spatstat)
# Prepare the dataset:
X = trees_N4
x_left = x_left_N4
x_right = x_right_N4
y_bottom = y_bottom_N4
y_top = y_top_N4

z_beta = list(refor = cov_refor, slope = cov_slope)
z_alpha = list(tmi = cov_tmi, tdensity = cov_tdensity)
z_omega = list(slope = cov_slope, reserv = cov_reserv)

# Determine the union of rectangles:
W = owin(c(x_left[1], x_right[1]), c(y_bottom[1], y_top[1]))
if (length(x_left) >= 2) {
  for (i in 2:length(x_left)) {
    W2 = owin(c(x_left[i], x_right[i]), c(y_bottom[i], y_top[i]))
    W = union.owin(W, W2)
  }
}

# Dilated observation window:
W_dil = dilation.owin(W, 100)


# Default parameters for prior distributions:
control = list(NStep = 200, BurnIn = 100, SamplingFreq = 10)


# MCMC estimation:
Output = estintp(X, control, x_left, x_right, y_bottom, y_top, W_dil,
                 z_beta, z_alpha, z_omega, verbose = FALSE)


# Text output
print_outputs(Output)

}
