% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagmatrix.R
\name{lagmatrix}
\alias{lagmatrix}
\title{Creates Lagmatrix of Estimated Coefficients}
\usage{
lagmatrix(fit, returnplot = F)
}
\arguments{
\item{fit}{Fitted VAR, VARX or VARMA model.}

\item{returnplot}{TRUE or FALSE: return plot of lag matrix or not.}
}
\value{
A list with estimated lag matrix of the VAR model, or lag matrices
of the VARX or VARMA model. The rows contain the responses, the columns
contain the predictors.
}
\description{
Creates Lagmatrix of Estimated Coefficients
}
\examples{
data(var.example)
mod <- sparseVAR(Y=scale(Y.var), selection="cv")
Lhat <- lagmatrix(fit=mod)
}
